/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bari;

import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.WallAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class BarrierAbility
extends WallAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "barrier", new Pair[]{ImmutablePair.of((Object)"The user creates an impenetrable wall in front of themselves, which shields them from attacks.", null)});
    private static final int HOLD_TIME = 600;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 400;
    public static final AbilityCore<BarrierAbility> INSTANCE = new AbilityCore.Builder<BarrierAbility>("Barrier", AbilityCategory.DEVIL_FRUITS, BarrierAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 400.0f), ContinuousComponent.getTooltip(600.0f)).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).setBypassGriefRule().build();

    public BarrierAbility(AbilityCore<BarrierAbility> core) {
        super(core);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        float cooldown = 100.0f + this.continuousComponent.getContinueTime() / 2.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    @Override
    public int getHoldTime() {
        return 600;
    }

    @Override
    public int getThickness() {
        return 1;
    }

    @Override
    public int getHeight() {
        return 6;
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public Block getWallBlock() {
        return (Block)ModBlocks.BARRIER.get();
    }

    @Override
    public BlockProtectionRule getGriefingRule() {
        return GRIEF_RULE;
    }

    @Override
    public boolean stopAfterUse() {
        return false;
    }
}

