/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bari;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.bari.BarrierbilityStairsProjectile;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class BarrierbilityStairsAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "barrierbility_stairs", new Pair[]{ImmutablePair.of((Object)"By shaping the Barrier, the user can create stairs.", null)});
    private static final int COOLDOWN = 100;
    public static final AbilityCore<BarrierbilityStairsAbility> INSTANCE = new AbilityCore.Builder<BarrierbilityStairsAbility>("Barrierbility Stairs", AbilityCategory.DEVIL_FRUITS, BarrierbilityStairsAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f), ContinuousComponent.getTooltip()).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private List<BlockPos> posList = new ArrayList<BlockPos>();

    public BarrierbilityStairsAbility(AbilityCore<BarrierbilityStairsAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.posList.isEmpty()) {
            BarrierbilityStairsProjectile proj = new BarrierbilityStairsProjectile(entity.field_70170_p, entity);
            entity.field_70170_p.func_217376_c((Entity)proj);
            proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 2.0f, 1.0f);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        for (BlockPos pos : this.posList) {
            if (entity.field_70170_p.func_180495_p(pos).func_177230_c() != ModBlocks.BARRIER.get()) continue;
            entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.posList.clear();
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    public void fillBlocksList(List<BlockPos> entityList) {
        this.posList.addAll(entityList);
    }
}

