/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.DiableJambeAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ConcasseAbility
extends DropHitAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "concasse", new Pair[]{ImmutablePair.of((Object)"Leaps forward kicking all nearby enemies for moderate damage and knocking them down", null)});
    private static final int COOLDOWN = 300;
    private static final float RANGE = 1.7f;
    private static final float DAMAGE = 15.0f;
    public static final AbilityCore<ConcasseAbility> INSTANCE = new AbilityCore.Builder<ConcasseAbility>("Concasse", AbilityCategory.STYLE, ConcasseAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), DealDamageComponent.getTooltip(15.0f), RangeComponent.getTooltip(1.7f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setUnlockCheck(ConcasseAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private Interval particleInterval = new Interval(2);

    public ConcasseAbility(AbilityCore<ConcasseAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.dealDamageComponent, this.rangeComponent, this.animationComponent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::onContinuityEnd);
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.particleInterval.restartIntervalToZero();
        Vector3d speed = entity.func_70040_Z();
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, 1.3, speed.field_72449_c);
        this.animationComponent.start(entity, ModAnimations.PITCH_SPIN);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75100_b) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (entity.field_70143_R > 0.0f) {
            boolean targetHurt = false;
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 1.7f);
            targets.remove(entity);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target) || entity.func_233580_cy_().func_177956_o() <= target.func_233580_cy_().func_177956_o() || !this.dealDamageComponent.hurtTarget(entity, target, 15.0f)) continue;
                target.func_195064_c(new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), 20, 0, false, false));
                AbilityHelper.setDeltaMovement((Entity)target, entity.func_213322_ci().field_72450_a, -1.5, entity.func_213322_ci().field_72449_c);
                targetHurt = true;
            }
            if (targetHurt) {
                if (!entity.field_70170_p.field_72995_K) {
                    ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
                }
                this.continuousComponent.stopContinuity(entity);
            }
        }
        if (this.particleInterval.canTick()) {
            boolean isAbilityEnabled;
            DiableJambeAbility diableJambeAbility = AbilityDataCapability.get(entity).getEquippedAbility(DiableJambeAbility.INSTANCE);
            boolean bl = isAbilityEnabled = diableJambeAbility != null && diableJambeAbility.isContinuous();
            if (isAbilityEnabled && !entity.func_233570_aj_()) {
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CONCASSE_DIABLE.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 1.5, entity.func_226281_cx_());
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    @Override
    public void onLanding(LivingEntity entity) {
    }

    @Override
    public float getContinueTime(LivingEntity entity) {
        return 60.0f;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(ModQuests.BLACK_LEG_TRIAL_01);
    }
}

