/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.ExtraHachisAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DiableJambeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "diable_jambe", new Pair[]{ImmutablePair.of((Object)"The user heats up their leg, dealing additional damage and shortly setting the target on fire (Enhances all Blackleg attacks)", null)});
    private static final float HOLD_TIME = 600.0f;
    private static final float MIN_COOLDOWN = 80.0f;
    private static final float MAX_COOLDOWN = 680.0f;
    public static final AbilityCore<DiableJambeAbility> INSTANCE = new AbilityCore.Builder<DiableJambeAbility>("Diable Jambe", AbilityCategory.STYLE, DiableJambeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(80.0f, 680.0f), ContinuousComponent.getTooltip(600.0f), ChangeStatsComponent.getTooltip()).setUnlockCheck(DiableJambeAbility::canUnlock).setSourceElement(SourceElement.FIRE).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.HOT_BOILING_SPECIAL_ARM).setColor("#FFBB44AA").build();
    private static final AbilityAttributeModifier DIABLE_JAMBE_STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("e3ae074c-40a9-49ff-aa3b-7cc9b98ddc2d"), INSTANCE, "Diable Jambe Attack Multiplier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier DIABLE_JAMBE_ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("a984413a-7459-4989-8362-7c46a2663f0e"), INSTANCE, "Diable Jambe Speed Multiplier", (double)0.4f, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onContinuityStartEvent).addTickEvent(100, this::onContinuityTickEvent).addEndEvent(100, this::onContinuityEndEvent);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent(this);
    private boolean frozen = false;

    public DiableJambeAbility(AbilityCore<DiableJambeAbility> core) {
        super(core);
        this.isNew = true;
        Predicate<LivingEntity> isContinuityActive = entity -> this.continuousComponent.isContinuous();
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)DIABLE_JAMBE_ATTACK_SPEED_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)DIABLE_JAMBE_STRENGTH_MODIFIER, isContinuityActive);
        this.addComponents(this.continuousComponent, this.skinOverlayComponent, this.statsComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 600.0f);
    }

    private void onContinuityStartEvent(LivingEntity entity, IAbility ability) {
        this.frozen = false;
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        ExtraHachisAbility extraHachis = abilityProps.getEquippedAbility(ExtraHachisAbility.INSTANCE);
        if (extraHachis != null) {
            extraHachis.getComponent(ModAbilityKeys.ALT_MODE).ifPresent(component -> component.setMode(entity, ExtraHachisAbility.Mode.POELE_A_FRIRE));
        }
    }

    private void onContinuityTickEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70644_a((Effect)ModEffects.FROZEN.get())) {
            this.frozen = true;
            AbilityHelper.reduceEffect(entity.func_70660_b((Effect)ModEffects.FROZEN.get()), 1.1f);
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (entity.func_70644_a((Effect)ModEffects.FROSTBITE.get())) {
            this.frozen = true;
            AbilityHelper.reduceEffect(entity.func_70660_b((Effect)ModEffects.FROSTBITE.get()), 1.5);
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DIABLE_JAMBE.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    private void onContinuityEndEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, (this.frozen ? 160.0f : 80.0f) + this.continuousComponent.getContinueTime());
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        ExtraHachisAbility extraHachis = abilityProps.getEquippedAbility(ExtraHachisAbility.INSTANCE);
        if (extraHachis != null) {
            extraHachis.getComponent(ModAbilityKeys.ALT_MODE).ifPresent(component -> component.revertToDefault(entity));
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(ModQuests.BLACK_LEG_TRIAL_05);
    }
}

