/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SkywalkAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "skywalk", new Pair[]{ImmutablePair.of((Object)"Allows the user to kick the air beneath them and launch themselves into the air", null)});
    private static final int MAX_JUMPS = 6;
    private static final float SHORT_COOLDOWN_PER_STACK = 10.0f;
    private static final float LONG_COOLDOWN_PER_STACK = 50.0f;
    public static final AbilityCore<SkywalkAbility> INSTANCE = new AbilityCore.Builder<SkywalkAbility>("Skywalk", AbilityCategory.STYLE, SkywalkAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, AbilityHelper.createShortLongCooldownStat(10.0f, 50.0f), StackComponent.getTooltip(6)).setUnlockCheck(SkywalkAbility::canUnlock).build();
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.GEPPO_LIKE, new AbilityPool2[0]);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTaken);
    private final StackComponent stackComponent = new StackComponent(this, 6);
    private boolean hasFallDamage = true;
    private boolean hadGravity = false;
    private int noGravityTime = 8;

    public SkywalkAbility(AbilityCore<SkywalkAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.poolComponent, this.damageTakenComponent, this.stackComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        int stacksUsed = 1;
        if (this.noGravityTime <= 0) {
            this.hadGravity = !entity.func_189652_ae();
        }
        Vector3d movement = entity.func_70040_Z().func_72432_b();
        if (entity.func_70090_H()) {
            movement = movement.func_186678_a(2.5);
            stacksUsed = this.stackComponent.getStacks();
        } else {
            movement = movement.func_186678_a(entity.func_233570_aj_() ? 2.0 : 1.5);
        }
        entity.func_189654_d(true);
        this.noGravityTime = 8;
        if (entity.field_70125_A < -40.0f) {
            movement = movement.func_72441_c(0.0, -(movement.field_72448_b - movement.field_72448_b / 2.0), 0.0);
        }
        AbilityHelper.setDeltaMovement((Entity)entity, movement.field_72450_a, movement.field_72448_b, movement.field_72449_c);
        this.stackComponent.addStacks(entity, this, -stacksUsed);
        this.hasFallDamage = false;
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GEPPO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + this.random.nextFloat() / 3.0f);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GEPPO.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        if (this.stackComponent.getStacks() <= 0) {
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
            this.stackComponent.setStacks(entity, this, 6);
        } else {
            this.cooldownComponent.startCooldown(entity, 10.0f);
        }
    }

    public void tickEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && !this.hasFallDamage && this.stackComponent.getStacks() < this.stackComponent.getDefaultStacks() && entity.func_233570_aj_() && entity.field_70170_p.func_82737_E() > this.getLastUseGametime() + 10L) {
            this.resetStacks(entity);
        }
        if (!entity.field_70170_p.field_72995_K && this.noGravityTime-- <= 0 && this.hadGravity) {
            entity.func_189654_d(false);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.resetStacks(entity);
            return 0.0f;
        }
        return damage;
    }

    private void resetStacks(LivingEntity entity) {
        if (this.stackComponent.getStacks() != this.stackComponent.getDefaultStacks()) {
            this.cooldownComponent.stopCooldown(entity);
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
        }
        this.stackComponent.setStacks(entity, this, 6);
        this.hasFallDamage = true;
    }

    private float getCooldownTicks() {
        return (float)(this.stackComponent.getDefaultStacks() - this.stackComponent.getStacks()) * 50.0f;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("hasFallDamage", this.hasFallDamage);
        nbt.func_74757_a("hadGravity", this.hadGravity);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasFallDamage = nbt.func_74767_n("hasFallDamage");
        this.hadGravity = nbt.func_74767_n("hadGravity");
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(ModQuests.BLACK_LEG_TRIAL_04);
    }
}

