/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveStatBonusAbility;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class BrawlerPassiveBonusesAbility
extends PassiveStatBonusAbility {
    private static final UUID BRAWLER_ATTACK_BONUS_UUID = UUID.fromString("4e4d55e7-774b-4010-8722-a15f9da99807");
    private static final Predicate<LivingEntity> BRAWLER_CHECK = entity -> {
        ItemStack heldItem = entity.func_184614_ca();
        return heldItem.func_190926_b();
    };
    private static final AbilityDescriptionLine.IDescriptionLine<BrawlerPassiveBonusesAbility> TOOLTIP = (entity, ability) -> {
        ITextComponent statText;
        ITextComponent[] lines = new ITextComponent[2];
        lines[0] = new StringTextComponent("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_STATS.getString() + "\u00a7r");
        TranslationTextComponent attrName = new TranslationTextComponent(((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_233754_c_());
        float value = (float)ability.getBonus(entity);
        lines[1] = statText = new AbilityStat.Builder((ITextComponent)attrName, value).withSign("+").build().getStatDescription(2);
        StringBuilder sb = new StringBuilder();
        int lineId = 0;
        for (ITextComponent text : lines) {
            boolean hasFollowingLine = lineId++ < lines.length - 1;
            sb.append(text.getString() + (hasFollowingLine ? "\n" : ""));
        }
        return new StringTextComponent(sb.toString());
    };
    public static final AbilityCore<BrawlerPassiveBonusesAbility> INSTANCE = new AbilityCore.Builder<BrawlerPassiveBonusesAbility>("Brawler Passive Bonuses", AbilityCategory.STYLE, AbilityType.PASSIVE, BrawlerPassiveBonusesAbility::new).setIcon(ModResources.PERK_ICON).addDescriptionLine(TOOLTIP).setUnlockCheck(BrawlerPassiveBonusesAbility::canUnlock).build();

    public BrawlerPassiveBonusesAbility(AbilityCore<BrawlerPassiveBonusesAbility> core) {
        super(core);
        this.pushDynamicAttribute((Attribute)ModAttributes.PUNCH_DAMAGE.get(), entity -> this.getModifier((LivingEntity)entity));
    }

    private AttributeModifier getModifier(LivingEntity entity) {
        double bonus = this.getBonus(entity);
        return new AttributeModifier(BRAWLER_ATTACK_BONUS_UUID, "Brawler Punch Bonus", bonus, AttributeModifier.Operation.ADDITION);
    }

    private double getBonus(LivingEntity entity) {
        return 2.0 + EntityStatsCapability.get(entity).getDoriki() * 5.0E-4;
    }

    private static boolean canUnlock(LivingEntity entity) {
        return EntityStatsCapability.get(entity).isBrawler();
    }

    @Override
    public Predicate<LivingEntity> getCheck() {
        return BRAWLER_CHECK;
    }
}

