/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoPistolProjectile;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PunchRushAbility
extends Ability {
    public static final AbilityCore<PunchRushAbility> INSTANCE = new AbilityCore.Builder<PunchRushAbility>("Punch Rush", AbilityCategory.STYLE, PunchRushAbility::new).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::repeaterTriggerEvent).addStopEvent(this::repeaterStopEvent);
    private int waves = 30;
    private int punchesPerWave = 5;

    public PunchRushAbility(AbilityCore<PunchRushAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.repeaterComponent);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.repeaterComponent.start(entity, this.waves, 1);
        }
    }

    private void repeaterTriggerEvent(LivingEntity entity, IAbility ability) {
        float speed = 2.2f;
        int projectileSpace = 2;
        float projDmageReduction = 0.6f;
        for (int i = 0; i < this.punchesPerWave; ++i) {
            GomuGomuNoPistolProjectile projectile = new GomuGomuNoPistolProjectile(entity.field_70170_p, entity);
            projectile.setEntityCollisionSize(1.25);
            projectile.setMaxLife(3);
            projectile.setDamage(projectile.getDamage() * (1.0f - projDmageReduction));
            projectile.setMaxLife((int)((double)projectile.getMaxLife() * 0.75));
            double px = entity.func_226277_ct_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble();
            double py = entity.func_226280_cw_() + WyHelper.randomWithRange(0, projectileSpace) + WyHelper.randomDouble();
            double pz = entity.func_226281_cx_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble();
            projectile.func_70012_b(px, py, pz, 0.0f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)projectile);
            projectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, speed, 3.0f);
        }
        entity.func_226292_a_(Hand.MAIN_HAND, true);
    }

    private void repeaterStopEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, WyHelper.secondsToTicks(10.0f));
    }

    public void setWaveDetails(int waves, int punchesPerWave) {
        this.waves = waves;
        this.punchesPerWave = punchesPerWave;
    }
}

