/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SpinningBrawlAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "spinning_brawl", new Pair[]{ImmutablePair.of((Object)"Grabs a nearby enemy spinning them around damaging any nearby entity it touches, and ending by throwing the grabbed entity a few blocks away.", null)});
    private static final double THROW_POWER_XZ = 2.0;
    private static final double THROW_POWER_Y = 0.5;
    private static final int SPIN_DAMAGE = 10;
    private static final int MAIN_DAMAGE = 30;
    private static final int COOLDOWN = 240;
    private static final int CHARGE_TIME = 60;
    private static final int THROW_TIME = 40;
    private static final int PULL_TIME = 200;
    public static final AbilityCore<SpinningBrawlAbility> INSTANCE = new AbilityCore.Builder<SpinningBrawlAbility>("Spinning Brawl", AbilityCategory.STYLE, SpinningBrawlAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ChargeComponent.getTooltip(60.0f), DealDamageComponent.getTooltip(30.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setUnlockCheck(SpinningBrawlAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(100, this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent(this, true, false, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addTryHitEvent(this::tryHitEvent).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private final Interval clearHitsInterval = new Interval(20);

    public SpinningBrawlAbility(AbilityCore<SpinningBrawlAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.dealDamageComponent, this.chargeComponent, this.continuousComponent, this.hitTrackerComponent, this.animationComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent);
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.isCharging()) {
            this.chargeComponent.stopCharging(entity);
            return;
        }
        this.clearHitsInterval.restartIntervalToZero();
        if (this.continuousComponent.isContinuous() && (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE || this.grabComponent.getState() == GrabEntityComponent.GrabState.PULLING)) {
            this.grabComponent.release(entity);
            this.continuousComponent.stopContinuity(entity);
        } else if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE && this.grabComponent.grabNearest(entity, false)) {
            this.grabComponent.triggerPulling(entity);
        } else {
            this.continuousComponent.startContinuity(entity);
        }
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous() || this.grabComponent.hasGrabbedEntity()) {
            return HitTriggerComponent.HitResult.PASS;
        }
        return HitTriggerComponent.HitResult.HIT;
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous() || this.grabComponent.hasGrabbedEntity()) {
            return true;
        }
        if (this.grabComponent.grabManually(entity, target)) {
            this.grabComponent.startPulling(entity);
        }
        target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
        return false;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE) {
            return;
        }
        if (!this.grabComponent.canContinueGrab(entity)) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (this.grabComponent.getState() != GrabEntityComponent.GrabState.THROWN) {
            return;
        }
        LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
        if (grabbedTarget.func_233570_aj_()) {
            this.grabComponent.release(entity);
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        List<LivingEntity> targets = WyHelper.getNearbyLiving(grabbedTarget.func_213303_ch(), (IWorld)entity.field_70170_p, grabbedTarget.func_213311_cf(), grabbedTarget.func_213302_cg(), grabbedTarget.func_213311_cf(), null);
        targets.remove(grabbedTarget);
        Vector3d dir = entity.func_70040_Z().func_72432_b().func_186678_a(2.0);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 10.0f)) continue;
            AbilityHelper.setDeltaMovement((Entity)target, dir.field_72450_a, 0.5, dir.field_72449_c);
        }
        if (this.clearHitsInterval.canTick()) {
            this.hitTrackerComponent.clearHits();
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
            this.grabComponent.release(entity);
        }
        if (!this.grabComponent.canContinueGrab(entity)) {
            this.cooldownComponent.startCooldown(entity, 240.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
    }

    public void onChargeTick(LivingEntity entity, IAbility ability) {
        float adjustedYaw;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (super.canUse(entity).isFail() || !this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.stopCharging(entity);
            return;
        }
        LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1));
        grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 2, 3));
        Vector3d direction = grabbedTarget.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b();
        float targetYaw = (float)Math.toDegrees(Math.atan2(direction.field_72449_c, direction.field_72450_a)) - 90.0f;
        entity.field_70177_z = entity.field_70126_B = (adjustedYaw = (targetYaw + 10.0f) % 360.0f);
        entity.field_70127_C = 0.0f;
        entity.field_70125_A = 0.0f;
        if (entity instanceof PlayerEntity) {
            EnumSet<SPlayerPositionLookPacket.Flags> flags = EnumSet.of(SPlayerPositionLookPacket.Flags.X, SPlayerPositionLookPacket.Flags.Y, SPlayerPositionLookPacket.Flags.Z);
            ((ServerPlayerEntity)entity).field_71135_a.func_175089_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A, flags);
        }
        float distance = 2.0f;
        Vector3d lookVec = entity.func_70040_Z().func_72432_b();
        Vector3d pos = new Vector3d(lookVec.field_72450_a * (double)distance, (double)(entity.func_70047_e() / 2.0f) + lookVec.field_72448_b * (double)distance, lookVec.field_72449_c * (double)distance);
        AbilityHelper.setDeltaMovement((Entity)grabbedTarget, entity.func_213303_ch().func_178787_e(pos).func_178788_d(grabbedTarget.func_213303_ch()), true);
        List<LivingEntity> targets = WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, grabbedTarget.func_213311_cf(), grabbedTarget.func_213302_cg(), grabbedTarget.func_213311_cf(), ModEntityPredicates.getEnemyFactions(entity));
        targets.remove(grabbedTarget);
        if (!HakiHelper.hasHardeningActive(entity)) {
            targets.removeIf(target -> DevilFruitCapability.get(entity).isLogia());
        }
        Vector3d dir = lookVec.func_186678_a(2.0);
        for (LivingEntity target2 : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target2) || !this.dealDamageComponent.hurtTarget(entity, target2, 10.0f)) continue;
            AbilityHelper.setDeltaMovement((Entity)target2, dir.field_72450_a, 0.5, dir.field_72449_c);
        }
        if (this.clearHitsInterval.canTick()) {
            this.hitTrackerComponent.clearHits();
        }
    }

    public void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabComponent.canContinueGrab(entity)) {
            LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
            if (this.dealDamageComponent.hurtTarget(entity, grabbedTarget, 30.0f)) {
                grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 80, 0));
            }
            this.grabComponent.throwTarget(entity, 2.0, 0.5);
            this.continuousComponent.startContinuity(entity, 40.0f);
        } else {
            this.cooldownComponent.startCooldown(entity, 240.0f);
        }
        this.animationComponent.stop(entity);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBrawler() && questProps.hasFinishedQuest(ModQuests.BRAWLER_TRIAL_02);
    }
}

