/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.buki;

import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchTriggerAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.FreshFireProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SSyncAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class BukimorphoseAbility
extends PunchTriggerAbility {
    public static final AbilityCore<BukimorphoseAbility> INSTANCE = new AbilityCore.Builder<BukimorphoseAbility>("Bukimorphose", AbilityCategory.DEVIL_FRUITS, BukimorphoseAbility::new).build();
    private Mode mode = Mode.SWORD;
    boolean released = false;
    boolean exploded = false;

    public BukimorphoseAbility(AbilityCore<BukimorphoseAbility> core) {
        super(core);
        this.onStartContinuityEvent = this::onStartContinuity;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.beforeContinuityStopEvent = this::beforeContinuityStopEvent;
        this.stopAfterUsage(false);
        this.onSwingEvent = this::onSwingEvent;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    private void duringCooldownEvent(PlayerEntity player, int i) {
        if (this.mode == Mode.MISSILE && !this.exploded) {
            float maxSpeed = 4.0f;
            Vector3d vec = player.func_70040_Z();
            AbilityHelper.setDeltaMovement((Entity)player, vec.field_72450_a * (double)maxSpeed, vec.field_72448_b * (double)maxSpeed, vec.field_72449_c * (double)maxSpeed);
            if (player.field_70123_F || player.field_70124_G) {
                ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)player, player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 6.0f);
                explosion.setExplosionSound(true);
                explosion.setDamageOwner(false);
                explosion.setDestroyBlocks(true);
                explosion.setFireAfterExplosion(true);
                explosion.setStaticDamage(100.0f);
                explosion.setSmokeParticles(new CommonExplosionParticleEffect(6));
                explosion.setDamageEntities(true);
                explosion.doExplosion();
                this.exploded = true;
            }
        }
    }

    private boolean onStartContinuity(PlayerEntity player) {
        this.released = false;
        return true;
    }

    private boolean onSwingEvent(PlayerEntity player) {
        this.stopAfterUsage(false);
        if (this.mode == Mode.FIRE) {
            FreshFireProjectile proj = new FreshFireProjectile(player.field_70170_p, (LivingEntity)player, this);
            player.field_70170_p.func_217376_c((Entity)proj);
            proj.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.0f, 10.0f);
        } else if (this.mode == Mode.GATLING) {
            NormalBulletProjectile proj = new NormalBulletProjectile(player.field_70170_p, (LivingEntity)player);
            player.field_70170_p.func_217376_c((Entity)proj);
            proj.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, 2.0f);
        } else if (this.mode == Mode.CANNON) {
            this.stopAfterUsage(true);
            CannonBallProjectile proj = new CannonBallProjectile(player.field_70170_p, (LivingEntity)player);
            this.setMaxCooldown(2.0);
            player.field_70170_p.func_217376_c((Entity)proj);
            proj.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, 2.0f);
        } else if (this.mode == Mode.MISSILE) {
            this.stopAfterUsage(true);
            this.setMaxCooldown(8.0);
            this.exploded = false;
        }
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
        if (i % (player.func_226271_bk_() ? 10 : 40) == 0 && !this.released) {
            this.mode = this.mode.getNext();
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Ability mode set to: " + (Object)((Object)this.mode)), Util.field_240973_b_);
            WyNetwork.sendTo(new SSyncAbilityPacket(player.func_145782_y(), this), player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((LivingEntity)player, this), (Entity)player);
        }
    }

    private boolean beforeContinuityStopEvent(PlayerEntity player) {
        if (!this.released) {
            this.released = true;
            return false;
        }
        return true;
    }

    public static enum Mode {
        SWORD,
        CANNON,
        GATLING,
        FIRE,
        MISSILE;


        public Mode getNext() {
            return (long)this.ordinal() == Arrays.stream(Mode.values()).count() - 1L ? SWORD : Mode.values()[this.ordinal() + 1];
        }
    }
}

