/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.carnivaltricks;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class IchirinZashiAbility
extends DropHitAbility {
    private static final int COOLDOWN = 200;
    private static final float RANGE = 3.5f;
    private static final float DAMAGE = 20.0f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ichirin_zashi", new Pair[]{ImmutablePair.of((Object)"The user leaps into the air and drops down on ground hitting the target on their descent", null)});
    public static final AbilityCore<IchirinZashiAbility> INSTANCE = new AbilityCore.Builder<IchirinZashiAbility>("Ichirin Zashi", AbilityCategory.STYLE, IchirinZashiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), DealDamageComponent.getTooltip(20.0f), RangeComponent.getTooltip(3.5f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.SLASH).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public IchirinZashiAbility(AbilityCore<IchirinZashiAbility> core) {
        super(core);
        this.addComponents(this.dealDamageComponent, this.rangeComponent, this.animationComponent);
        this.continuousComponent.addStartEvent(100, this::onStartContinuityEvent);
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
    }

    @Override
    public void onLanding(LivingEntity entity) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 3.5f);
        targets.remove(entity);
        AbilityDamageSource source = (AbilityDamageSource)((Object)ModDamageSource.causeAbilityDamage(entity, this.getCore()).setSlash());
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !entity.func_70685_l((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 20.0f, source);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 200.0f);
        this.animationComponent.stop(entity);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() > 10.0f && !this.hasLanded()) {
            if (entity.func_233570_aj_()) {
                this.setLanded(true);
            } else if (entity.func_184187_bx() != null && entity.func_184187_bx().func_233570_aj_()) {
                this.setLanded(true);
            }
        }
    }

    private void onStartContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.STAB_DOWN);
        Vector3d speed = WyHelper.propulsion(entity, 1.0, 1.0);
        if (entity.func_184187_bx() != null) {
            AbilityHelper.setDeltaMovement(entity.func_184187_bx(), speed.field_72450_a, 1.3, speed.field_72449_c);
            return;
        }
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, 1.3, speed.field_72449_c);
    }
}

