/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.chiyu;

import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HealComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HealingTouchAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "healing_touch", new Pair[]{ImmutablePair.of((Object)"Touch the target to heal them", null)});
    private static final float COOLDOWN = 200.0f;
    private static final float HEAL_AMOUNT = 20.0f;
    public static final AbilityCore<HealingTouchAbility> INSTANCE = new AbilityCore.Builder<HealingTouchAbility>("Healing Touch", AbilityCategory.DEVIL_FRUITS, HealingTouchAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), HealComponent.getTooltip(20.0f)).setSourceType(SourceType.FIST).build();
    private final HealComponent healComponent = new HealComponent(this);

    public HealingTouchAbility(AbilityCore<HealingTouchAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.addComponents(this.healComponent);
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.hitTriggerComponent.addTryHitEvent(80, this::hitEvent);
    }

    private HitTriggerComponent.HitResult hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.canActivate().test(entity)) {
            this.healComponent.healTarget(entity, target, 20.0f);
            target.func_195064_c(new EffectInstance(Effects.field_76428_l, 400, 1));
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.HEALING_TOUCH.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            this.increaseUses();
            return HitTriggerComponent.HitResult.FAIL;
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    @Override
    public float getPunchCooldown() {
        return 200.0f;
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public boolean isParallel() {
        return true;
    }
}

