/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateColaAmountPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ColaBackpackBonusAbility
extends PassiveAbility2 {
    public static final int EXTRA_COLA = 500;
    public static final AbilityCore<ColaBackpackBonusAbility> INSTANCE = new AbilityCore.Builder<ColaBackpackBonusAbility>("Cola Backpack Bonus", AbilityCategory.EQUIPMENT, AbilityType.PASSIVE, ColaBackpackBonusAbility::new).setHidden().setUnlockCheck(ColaBackpackBonusAbility::canUnlock).build();

    public ColaBackpackBonusAbility(AbilityCore<ColaBackpackBonusAbility> ability) {
        super(ability);
        this.addRemoveEvent(this::removeEvent);
    }

    private void removeEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof ServerPlayerEntity) {
            IEntityStats props = EntityStatsCapability.get(entity);
            int cola = MathHelper.func_76125_a((int)props.getCola(), (int)0, (int)(props.getMaxCola() - 500));
            props.setCola(cola);
            WyNetwork.sendTo(new SUpdateColaAmountPacket(entity), (PlayerEntity)((ServerPlayerEntity)entity));
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        return ItemsHelper.hasItemInSlot(entity, EquipmentSlotType.CHEST, (Item)ModArmors.COLA_BACKPACK.get());
    }
}

