/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateColaAmountPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ColaOverdriveAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "cola_overdrive", new Pair[]{ImmutablePair.of((Object)"The user absorbs cola from their reserves to boost their physical abilities.", null)});
    private static final int DRAIN_PER_TICK = 2;
    private static final float HOLD_TIME = 300.0f;
    private static final float BASE_COOLDOWN = 100.0f;
    private static final float COOLDOWN_PER_TICK = 1.0f;
    private static final AbilityDescriptionLine.IDescriptionLine COLA_TOOLTIP = (e, a) -> {
        IEntityStats props = EntityStatsCapability.get(e);
        int half = (int)Math.floor((float)props.getMaxCola() / 2.0f);
        AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_COLA, half);
        return statBuilder.build().getStatDescription();
    };
    public static final AbilityCore<ColaOverdriveAbility> INSTANCE = new AbilityCore.Builder<ColaOverdriveAbility>("Cola Overdrive", AbilityCategory.RACIAL, ColaOverdriveAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f), COLA_TOOLTIP).setUnlockCheck(ColaOverdriveAbility::canUnlock).build();
    private static final AbilityAttributeModifier MOVEMENT_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("876d97f9-d8a1-487c-af05-ca97d90deb90"), INSTANCE, "Cola Overdrive Movement Speed Multiplier", 0.25, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier SWIM_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("876d97f9-d8a1-487c-af05-ca97d90deb90"), INSTANCE, "Cola Overdrive Swim Speed Multiplier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_HEIGHT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("74ddb8cc-1d53-47be-9ed8-ff1d26e8b665"), INSTANCE, "Cola Overdrive Jump Height Multiplier", 2.55, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier FALL_RESISTANCE_MODIFIER = new AbilityAttributeModifier(UUID.fromString("9120f731-0f9e-4c12-908c-1d4142daacce"), INSTANCE, "Cola Overdrive Fall Resistance Multiplier", 5.75, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_HEIGHT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("43f604bd-1ab3-4a27-9b10-bac40ade0e29"), INSTANCE, "Cola Overdrive Step Height Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);

    public ColaOverdriveAbility(AbilityCore<ColaOverdriveAbility> core) {
        super(core);
        this.isNew = true;
        Predicate<LivingEntity> isContinuityActive = entity -> this.continuousComponent.isContinuous();
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)MOVEMENT_SPEED_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ForgeMod.SWIM_SPEED, (AttributeModifier)SWIM_SPEED_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_HEIGHT_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.FALL_RESISTANCE, (AttributeModifier)FALL_RESISTANCE_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_HEIGHT_MODIFIER, isContinuityActive);
        super.addComponents(this.continuousComponent, this.changeStatsComponent);
        super.addCanUseCheck(this::canUseAbility);
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 300.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get(entity);
        props.alterCola(-2);
        if (entity instanceof ServerPlayerEntity) {
            WyNetwork.sendTo(new SUpdateColaAmountPacket(entity), (PlayerEntity)((ServerPlayerEntity)entity));
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 5, 0));
        AbilityUseResult result = this.canUseAbility(entity, this);
        if (result.isFail()) {
            entity.func_145747_a(result.getMessage(), Util.field_240973_b_);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f + 1.0f * this.continuousComponent.getContinueTime());
    }

    private AbilityUseResult canUseAbility(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get(entity);
        if (props.getCola() <= 0) {
            return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_COLA);
        }
        return AbilityUseResult.success();
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isCyborg();
    }
}

