/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.PacifistaEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class CyborgHelper {
    public static Ability.ICanUseEvent<LivingEntity, IAbility> hasEnoughCola(int colaNeeded) {
        return (entity, ability) -> {
            if (entity instanceof PacifistaEntity) {
                return AbilityUseResult.success();
            }
            IEntityStats props = EntityStatsCapability.get(entity);
            if (props.getCola() - colaNeeded < 0) {
                return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_COLA);
            }
            return AbilityUseResult.success();
        };
    }

    public static AbilityDescriptionLine.IDescriptionLine getColaTooltip(float cola) {
        return (e, a) -> {
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_COLA, cola);
            return statBuilder.build().getStatDescription();
        };
    }
}

