/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.StrongRightProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class StrongRightAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "strong_right", new Pair[]{ImmutablePair.of((Object)"The user punches the opponent with an extensible short range metal fist.", null)});
    private static final float COOLDOWN = 100.0f;
    public static final AbilityCore<StrongRightAbility> INSTANCE = new AbilityCore.Builder<StrongRightAbility>("Strong Right", AbilityCategory.RACIAL, StrongRightAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setUnlockCheck(StrongRightAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private boolean isShot;
    private AbilityProjectileEntity projectile;

    public StrongRightAbility(AbilityCore<StrongRightAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addCanUseCheck(BaraHelper::hasLimbs);
        this.addUseEvent(this::useEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity);
        this.projectile = this.projectileComponent.getShotProjectile();
        this.isShot = true;
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.NO_HANDS.get(), 200, 0));
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    private void tickEvent(LivingEntity entity, IAbility ability) {
        if (this.isShot) {
            if (this.projectile != null && !this.projectile.func_70089_S()) {
                this.projectile.func_70106_y();
                this.projectile = null;
            }
            entity.func_195063_d((Effect)ModEffects.NO_HANDS.get());
            this.isShot = false;
        }
    }

    private StrongRightProjectile createProjectile(LivingEntity entity) {
        StrongRightProjectile proj = new StrongRightProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isCyborg();
    }
}

