/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HealComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SPinCameraPacket;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUnpinCameraPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class FirstAidAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "first_aid", new Pair[]{ImmutablePair.of((Object)"Heals the user by shift-clicking or an ally by punching them.", null)});
    private static final int MIN_HEAL = 5;
    private static final int MAX_HEAL = 50;
    private static final float HOLD_TIME = 1000.0f;
    private static final float MIN_COOLDOWN = 300.0f;
    private final HealComponent healComponent = new HealComponent(this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addTryHitEvent(this::tryHitEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnDamageEvent(this::onDamageTaken);
    public static final AbilityCore<FirstAidAbility> INSTANCE = new AbilityCore.Builder<FirstAidAbility>("First Aid", AbilityCategory.STYLE, FirstAidAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), HealComponent.getTooltip(5.0f, 50.0f)).setSourceType(SourceType.FIST).setUnlockCheck(FirstAidAbility::canUnlock).build();
    private LivingEntity target;
    private boolean pinnedCamera = false;
    private Interval particleInterval = Interval.startAtMax(20);

    public FirstAidAbility(AbilityCore<FirstAidAbility> core) {
        super(core);
        this.isNew = true;
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.addComponents(this.continuousComponent, this.hitTriggerComponent, this.healComponent, this.damageTakenComponent);
        this.addCanUseCheck(AbilityHelper::requiresMedicBag);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_213453_ef()) {
            this.target = entity;
            this.continuousComponent.startContinuity(entity, 1000.0f);
        } else {
            this.continuousComponent.triggerContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.particleInterval.restartIntervalToZero();
        this.pinnedCamera = false;
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.target == null) {
            return;
        }
        if (this.continuousComponent.isInfinite()) {
            this.continuousComponent.setThresholdTime(entity, 1000.0f);
        } else if (this.target != null) {
            if (!this.pinnedCamera) {
                if (entity instanceof ServerPlayerEntity) {
                    WyNetwork.sendTo(SPinCameraPacket.pinClampedYawAndPitch(entity.field_70177_z, 10.0f, entity.field_70125_A, 10.0f), (PlayerEntity)((ServerPlayerEntity)entity));
                }
                this.pinnedCamera = true;
            }
            this.target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
        }
        if (this.particleInterval.canTick()) {
            FirstAidAbility.applyFirstAid(entity, this.target, this);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.target = null;
        if (entity instanceof ServerPlayerEntity) {
            WyNetwork.sendTo(new SUnpinCameraPacket(), (PlayerEntity)((ServerPlayerEntity)entity));
        }
        this.cooldownComponent.startCooldown(entity, 300.0f + this.continuousComponent.getContinueTime());
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous() && this.continuousComponent.isInfinite() && entity.func_184614_ca().func_190926_b()) {
            this.target = target;
            return HitTriggerComponent.HitResult.FAIL;
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damage >= 10.0f) {
            this.continuousComponent.stopContinuity(entity);
        }
        return damage;
    }

    private static void applyFirstAid(LivingEntity entity, LivingEntity target, FirstAidAbility ability) {
        Optional<ItemStack> medicBag = ItemsHelper.findItemInSlot(entity, EquipmentSlotType.CHEST, (Item)ModArmors.MEDIC_BAG.get());
        if (!medicBag.isPresent()) {
            return;
        }
        float healAmount = (float)WyHelper.percentage(1.0, target.func_110138_aP());
        ability.healComponent.healTarget(entity, target, healAmount);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.FIRST_AID.get(), (Entity)target, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        if (target.func_110143_aJ() >= target.func_110138_aP()) {
            ability.continuousComponent.stopContinuity(entity);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isDoctor() && questProps.hasFinishedQuest(ModQuests.DOCTOR_TRIAL_01);
    }
}

