/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class VirusZoneAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "virus_zone", new Pair[]{ImmutablePair.of((Object)"Throws a lingering splash potion of the mummy virus or ice oni virus.", null)});
    private static final TranslationTextComponent MUMMY_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.virus_zone_mummy", "Virus Zone: Mummy"));
    private static final TranslationTextComponent ICE_ONI_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.virus_zone_ice_oni", "Virus Zone: Ice Oni"));
    private static final ResourceLocation MUMMY_ICON = new ResourceLocation("mineminenomi", "textures/abilities/virus_zone_mummy.png");
    private static final ResourceLocation ICE_ONI_ICON = new ResourceLocation("mineminenomi", "textures/abilities/virus_zone_ice_oni.png");
    private static final int COOLDOWN = 400;
    private static final int EFFECT_TIME = 200;
    public static final AbilityCore<VirusZoneAbility> INSTANCE = new AbilityCore.Builder<VirusZoneAbility>("Virus Zone", AbilityCategory.STYLE, VirusZoneAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f)).setUnlockCheck(VirusZoneAbility::canUnlock).build();
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.MUMMY).addChangeModeEvent(this::onAltModeChange);

    public VirusZoneAbility(AbilityCore<VirusZoneAbility> core) {
        super(core);
        this.setDisplayName((ITextComponent)MUMMY_NAME);
        this.setDisplayIcon(MUMMY_ICON);
        this.isNew = true;
        this.addComponents(this.altModeComponent);
        this.addCanUseCheck(AbilityHelper::requiresMedicBag);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity livingEntity, IAbility ability) {
        PlayerEntity player;
        Optional<ItemStack> medicBag;
        ItemStack stack = new ItemStack((IItemProvider)Items.field_185156_bI);
        if (this.altModeComponent.getCurrentMode() == Mode.MUMMY) {
            stack = PotionUtils.func_185184_a((ItemStack)stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance((Effect)ModEffects.MUMMY_VIRUS.get(), 200, 1)}));
        } else if (this.altModeComponent.getCurrentMode() == Mode.ICE_ONI) {
            stack = PotionUtils.func_185184_a((ItemStack)stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance((Effect)ModEffects.ICE_ONI.get(), 200, 1)}));
        }
        PotionEntity potion = new PotionEntity(livingEntity.field_70170_p, livingEntity);
        potion.func_213884_b(stack);
        potion.field_70125_A -= -20.0f;
        potion.func_234612_a_((Entity)livingEntity, livingEntity.field_70125_A, livingEntity.field_70177_z, -20.0f, 1.0f, 0.0f);
        livingEntity.field_70170_p.func_217376_c((Entity)potion);
        if (livingEntity instanceof PlayerEntity && (medicBag = ItemsHelper.findItemInSlot((LivingEntity)(player = (PlayerEntity)livingEntity), EquipmentSlotType.CHEST, (Item)ModArmors.MEDIC_BAG.get())).isPresent()) {
            medicBag.get().func_222118_a(10, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        this.cooldownComponent.startCooldown(livingEntity, 400.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.MUMMY) {
            this.setDisplayName((ITextComponent)MUMMY_NAME);
            this.setDisplayIcon(MUMMY_ICON);
        } else if (mode == Mode.ICE_ONI) {
            this.setDisplayName((ITextComponent)ICE_ONI_NAME);
            this.setDisplayIcon(ICE_ONI_ICON);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isDoctor() && questProps.hasFinishedQuest(ModQuests.DOCTOR_TRIAL_04);
    }

    public static enum Mode {
        MUMMY,
        ICE_ONI;

    }
}

