/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doku;

import java.awt.Color;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.doku.VenomDemonAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class DokuFuguAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "doku_fugu", new Pair[]{ImmutablePair.of((Object)"The user covers themselves in poison creating a thin protective layer to damage. Cannot be used while %s is active.", (Object)new Object[]{VenomDemonAbility.INSTANCE})});
    private static final int COOLDOWN = 600;
    private static final int HOLD_TIME = 1200;
    public static final AbilityCore<DokuFuguAbility> INSTANCE = new AbilityCore.Builder<DokuFuguAbility>("Doku Fugu", AbilityCategory.DEVIL_FRUITS, DokuFuguAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(600.0f), ContinuousComponent.getTooltip(1200.0f)).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.DOKU_COATING).setColor(new Color(1.0f, 1.0f, 1.0f, 0.6f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);

    public DokuFuguAbility(AbilityCore<DokuFuguAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.skinOverlayComponent);
        this.addCanUseCheck((entity, ability) -> ((MorphInfo)ModMorphs.VENOM_DEMON.get()).isActive(entity) ? AbilityUseResult.fail(null) : AbilityUseResult.success());
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.PHYSICAL_MOVING_GUARD.get(), 2, 2, false, false));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }
}

