/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doku;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.doku.ChloroBallAbility;
import xyz.pixelatedw.mineminenomi.abilities.doku.DokuFuguAbility;
import xyz.pixelatedw.mineminenomi.abilities.doku.DokuGumoAbility;
import xyz.pixelatedw.mineminenomi.abilities.doku.HydraAbility;
import xyz.pixelatedw.mineminenomi.abilities.doku.VenomRoadAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class VenomDemonAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "venom_demon", new Pair[]{ImmutablePair.of((Object)"The user coats themselves in layers of strong corrosive venom, becoming a Venom Demon and leaving a highly poisonous trail. Also enhances all Posion abilities.", null)});
    private static final int COOLDOWN = 2000;
    private static final int HOLD_TIME = 1200;
    public static final AbilityCore<VenomDemonAbility> INSTANCE = new AbilityCore.Builder<VenomDemonAbility>("Venom Demon", AbilityCategory.DEVIL_FRUITS, VenomDemonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(2000.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).build();
    private static final AbilityAttributeModifier ATTACK_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Venom Demon Attack Modifier", 8.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Venom Demon Reach Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "Venom Demon Speed Modifier", 0.02, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Venom Demon Attack Speed Modifier", 0.15, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_ASSIST = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Venom Demon Step assist Modifier", 1.5, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_HEIGHT = new AbilityAttributeModifier(AttributeHelper.MORPH_JUMP_BOOST_UUID, INSTANCE, "Venom Demon Jump Height Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier KNOCKBACK_RESISTANCE = new AbilityAttributeModifier(AttributeHelper.MORPH_KNOCKBACK_RESISTANCE_UUID, INSTANCE, "Venom Demon Knockback Resistance Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(this::hitTriggerEvent).addTryHitEvent(this::tryHitEvent);

    public VenomDemonAbility(AbilityCore<VenomDemonAbility> core) {
        super(core);
        this.addComponents(this.hitTriggerComponent);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)ATTACK_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_ASSIST);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.FALL_RESISTANCE, (AttributeModifier)STEP_ASSIST);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_HEIGHT);
        this.statsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KNOCKBACK_RESISTANCE);
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
        this.continuousComponent.addTickEvent(this::duringContinuityEvent);
        this.continuousComponent.addEndEvent(80, this::earlyEndContinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
    }

    public void startContinuityEvent(LivingEntity entity, IAbility ability) {
        DokuFuguAbility dokuFugu;
        VenomRoadAbility venomRoad;
        DokuGumoAbility dokuGumo;
        ChloroBallAbility chloroBall;
        IAbilityData props = AbilityDataCapability.get(entity);
        HydraAbility hydra = props.getEquippedAbility(HydraAbility.INSTANCE);
        if (hydra != null) {
            hydra.setVenomMode(entity);
        }
        if ((chloroBall = props.getEquippedAbility(ChloroBallAbility.INSTANCE)) != null) {
            chloroBall.setVenomMode(entity);
        }
        if ((dokuGumo = props.getEquippedAbility(DokuGumoAbility.INSTANCE)) != null) {
            dokuGumo.setVenomMode(entity);
        }
        if ((venomRoad = props.getEquippedAbility(VenomRoadAbility.INSTANCE)) != null) {
            venomRoad.setVenomMode(entity);
        }
        if ((dokuFugu = props.getEquippedAbility(DokuFuguAbility.INSTANCE)) != null) {
            AbilityHelper.emergencyStopAbility(entity, dokuFugu);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.PHYSICAL_MOVING_GUARD.get(), 2, 3, false, false));
        if (!AbilityHelper.isWeakenedByKairosekiOrWater(entity)) {
            BlockPos.Mutable mutpos = new BlockPos.Mutable();
            for (int x = -1; x < 1; ++x) {
                for (int z = -1; z < 1; ++z) {
                    mutpos.func_189532_c(entity.func_226277_ct_() + (double)x, entity.func_226278_cu_(), entity.func_226281_cx_() + (double)z);
                    if (!entity.field_70170_p.func_180495_p(mutpos.func_177977_b()).func_185904_a().func_76220_a()) continue;
                    AbilityHelper.placeBlockIfAllowed(entity, (BlockPos)mutpos, ((Block)ModBlocks.DEMON_POISON.get()).func_176223_P(), DefaultProtectionRules.AIR_FOLIAGE);
                }
            }
        }
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.VENOM_DEMON.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void earlyEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 2000.0f);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        VenomRoadAbility venomRoad;
        DokuGumoAbility dokuGumo;
        ChloroBallAbility chloroBall;
        IAbilityData props = AbilityDataCapability.get(entity);
        HydraAbility hydra = props.getEquippedAbility(HydraAbility.INSTANCE);
        if (hydra != null) {
            hydra.setNormalMode(entity);
        }
        if ((chloroBall = props.getEquippedAbility(ChloroBallAbility.INSTANCE)) != null) {
            chloroBall.setNormalMode(entity);
        }
        if ((dokuGumo = props.getEquippedAbility(DokuGumoAbility.INSTANCE)) != null) {
            dokuGumo.setNormalMode(entity);
        }
        if ((venomRoad = props.getEquippedAbility(VenomRoadAbility.INSTANCE)) != null) {
            venomRoad.setNormalMode(entity);
        }
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.VENOM_DEMON.get();
    }

    @Override
    public float getContinuityHoldTime() {
        return 1200.0f;
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous() || !entity.func_184614_ca().func_190926_b()) {
            return HitTriggerComponent.HitResult.PASS;
        }
        return HitTriggerComponent.HitResult.HIT;
    }

    public boolean hitTriggerEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        source.setFistDamage().setSourceElement(SourceElement.POISON);
        target.func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), 100, 1));
        return true;
    }
}

