/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doru;

import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.doru.CandleChampionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.WallAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class CandleWallAbility
extends WallAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "candle_wall", new Pair[]{ImmutablePair.of((Object)"Creates a wax wall in front of the user", null)});
    private static final float COOLDOWN = 120.0f;
    public static final AbilityCore<CandleWallAbility> INSTANCE = new AbilityCore.Builder<CandleWallAbility>("Candle Wall", AbilityCategory.DEVIL_FRUITS, CandleWallAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(120.0f)).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).build();
    private int thiccness = 1;

    public CandleWallAbility(AbilityCore<CandleWallAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(100, this::onUseEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        boolean isAcitve;
        CandleChampionAbility candleChampionAbility = AbilityDataCapability.get(entity).getEquippedAbility(CandleChampionAbility.INSTANCE);
        if (candleChampionAbility != null && (isAcitve = candleChampionAbility.getComponent(ModAbilityKeys.CONTINUOUS).map(ContinuousComponent::isContinuous).orElse(false).booleanValue())) {
            this.thiccness = 2;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 120.0f);
    }

    @Override
    public int getThickness() {
        return this.thiccness;
    }

    @Override
    public int getHeight() {
        return 4;
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public Block getWallBlock() {
        return (Block)ModBlocks.WAX.get();
    }

    @Override
    public BlockProtectionRule getGriefingRule() {
        return GRIEF_RULE;
    }

    @Override
    public boolean stopAfterUse() {
        return true;
    }
}

