/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectroHelper;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GaugeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class SulongCheckAbility
extends PassiveAbility2 {
    public static final AbilityCore<SulongCheckAbility> INSTANCE = new AbilityCore.Builder<SulongCheckAbility>("Sulong Check", AbilityCategory.RACIAL, AbilityType.PASSIVE, SulongCheckAbility::new).setUnlockCheck(SulongCheckAbility::canUnlock).setHidden().build();

    public SulongCheckAbility(AbilityCore<SulongCheckAbility> core) {
        super(core);
        if (super.isClientSide()) {
            GaugeComponent gaugeComponent = new GaugeComponent(this, this::renderGauge);
            super.addComponents(gaugeComponent);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderGauge(PlayerEntity player, MatrixStack matrixStack, int posX, int posY, SulongCheckAbility ability) {
        RenderSystem.enableBlend();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
        if (ElectroHelper.canTransform(player.field_70170_p)) {
            RendererHelper.drawAbilityIcon(SulongAbility.INSTANCE, matrixStack, posX, posY - 38, 0, 32.0f, 32.0f);
        }
        RenderSystem.disableBlend();
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get(entity);
        return props.isMink();
    }
}

