/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanKarateHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KarakusagawaraSeikenAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "karakusagawara_seiken", new Pair[]{ImmutablePair.of((Object)"The user punches the air, which sends a shockwave through water vapor in the air", null)});
    private static final float COOLDOWN = 500.0f;
    private static final float CHARGE_TIME = 40.0f;
    private static final float RANGE = 10.0f;
    private static final float DAMAGE = 20.0f;
    private static final float WATER_DAMAGE_MUL = 2.5f;
    public static final AbilityCore<KarakusagawaraSeikenAbility> INSTANCE = new AbilityCore.Builder<KarakusagawaraSeikenAbility>("Karakusagawara Seiken", AbilityCategory.RACIAL, KarakusagawaraSeikenAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(500.0f), ChargeComponent.getTooltip(40.0f), FishmanKarateHelper.getWaterBuffedDamageStat(20.0f, 2.5f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE)).setSourceElement(SourceElement.SHOCKWAVE).setUnlockCheck(KarakusagawaraSeikenAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(100, this::onTickChargeEvent).addEndEvent(100, this::onEndChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public KarakusagawaraSeikenAbility(AbilityCore<KarakusagawaraSeikenAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.rangeComponent, this.dealDamageComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 40.0f);
    }

    private void onTickChargeEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KARAKUSAGAWARA_SEIKEN_CHARGING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    private void onEndChargeEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f);
        AbilityDamageSource source = (AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity);
        source.setUnavoidable();
        source.setInternal();
        Iterator<LivingEntity> iterator = targets.iterator();
        while (iterator.hasNext()) {
            LivingEntity target;
            float finalDamage = 20.0f * ((target = iterator.next()).func_70090_H() || FishmanKarateHelper.isInWater(entity) ? 2.5f : 1.0f);
            if (!this.dealDamageComponent.hurtTarget(entity, target, finalDamage, source)) continue;
            target.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 1));
        }
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isFishman() && props.getDoriki() >= 7500.0;
    }
}

