/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate.MizuShuryudanProjectile;

public class MizuShuryudanAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mizu_shuryudan", new Pair[]{ImmutablePair.of((Object)"Launches multiple bubbles in the direction the user is looking, these bubbles will linger around until an enemy comes close to them at which point they'll start targeting the enemy and move towards them.", null)});
    private static final int COOLDOWN = 240;
    public static final AbilityCore<MizuShuryudanAbility> INSTANCE = new AbilityCore.Builder<MizuShuryudanAbility>("Mizu Shuryudan", AbilityCategory.RACIAL, MizuShuryudanAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(100, this::triggerRepeaterEvent).addStopEvent(100, this::stopRepeaterEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private int projectilesSpawned = 5;

    public MizuShuryudanAbility(AbilityCore<MizuShuryudanAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.repeaterComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, this.projectilesSpawned, 5);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        float speed = 1.0f + entity.func_70681_au().nextFloat();
        this.projectileComponent.shoot(entity, speed, 10.0f);
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private MizuShuryudanProjectile createProjectile(LivingEntity entity) {
        MizuShuryudanProjectile projectile = new MizuShuryudanProjectile(entity.field_70170_p, entity);
        return projectile;
    }

    public void setProjectilesNumber(int projectiles) {
        this.projectilesSpawned = projectiles;
    }
}

