/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.events.FactionEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SamehadaShoteiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "samehada_shotei", new Pair[]{ImmutablePair.of((Object)"The user concentrates their power to their palms, sending melee damage back to its owner and pushing them a few blocks back", null)});
    private static final float HOLD_TIME = 200.0f;
    private static final float INTRERUPT_COOLDOWN = 200.0f;
    private static final float MIN_COOLDOWN = 100.0f;
    private static final float MAX_COOLDOWN = 400.0f;
    private static final float DAMAGE = 15.0f;
    public static final AbilityCore<SamehadaShoteiAbility> INSTANCE = new AbilityCore.Builder<SamehadaShoteiAbility>("Samehada Shotei", AbilityCategory.RACIAL, SamehadaShoteiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 400.0f), ContinuousComponent.getTooltip(200.0f)).setUnlockCheck(SamehadaShoteiAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onStartContinuityEvent).addTickEvent(100, this::onTickContinuityEvent).addEndEvent(100, this::onEndContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTakenEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public SamehadaShoteiAbility(AbilityCore<SamehadaShoteiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.animationComponent, this.poolComponent, this.damageTakenComponent, this.dealDamageComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 200.0f);
    }

    private void onStartContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
    }

    private void onTickContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, entity.func_70090_H() ? 2 : 1, false, false));
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.SAMEHADA.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    private void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 100.0f + this.continuousComponent.getContinueTime() * 2.0f);
    }

    private float onDamageTakenEvent(LivingEntity entity, IAbility ability, DamageSource source, float damage) {
        if (!this.continuousComponent.isContinuous()) {
            return damage;
        }
        Entity sourceEntity = source.func_76346_g();
        if (sourceEntity == null) {
            return damage;
        }
        if (sourceEntity instanceof LivingEntity && FactionEvents.isDirectHit(source) && this.dealDamageComponent.hurtTarget(entity, (LivingEntity)sourceEntity, 15.0f)) {
            Vector3d knockback = entity.func_213303_ch().func_178788_d(sourceEntity.func_213303_ch()).func_72432_b().func_186678_a(-2.0);
            AbilityHelper.setDeltaMovement(sourceEntity, knockback);
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
        this.continuousComponent.stopContinuity(entity);
        return 0.0f;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isFishman() && props.getDoriki() >= 3000.0;
    }
}

