/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gasu;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gasu.ShinokuniAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GastanetAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gastanet", new Pair[]{ImmutablePair.of((Object)"The user creates an explosion by detonating gas with their hands poisoning every enemy around the user.", null), ImmutablePair.of((Object)"If %s is active the nearby entities will instead get affected by whatever effect the user has at the moment. Allies will receive benefic effects while enemies will receive negative effects.", (Object)new Object[]{ShinokuniAbility.INSTANCE})});
    private static final UUID SHINOKUNI_RANGE_BONUS = UUID.fromString("05f3fc04-68e5-4f7b-a513-7237ad6fd643");
    private static final TargetsPredicate ALL_TARGETS = new TargetsPredicate();
    private static final int COOLDOWN = 160;
    private static final int RANGE = 8;
    public static final AbilityCore<GastanetAbility> INSTANCE = new AbilityCore.Builder<GastanetAbility>("Gastanet", AbilityCategory.DEVIL_FRUITS, GastanetAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), RangeComponent.getTooltip(8.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.EXPLOSION).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public GastanetAbility(AbilityCore<GastanetAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 64.0);
        ExplosionAbility explosion = AbilityHelper.newExplosion(null, entity.field_70170_p, mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c, 5.0f);
        explosion.setStaticDamage(40.0f);
        explosion.setDestroyBlocks(false);
        explosion.doExplosion();
        this.rangeComponent.getBonusManager().removeBonus(SHINOKUNI_RANGE_BONUS);
        if (((MorphInfo)ModMorphs.SHINOKUNI.get()).isActive(entity)) {
            this.rangeComponent.getBonusManager().addBonus(SHINOKUNI_RANGE_BONUS, "Shinokuni Range Bonus", BonusOperation.ADD, 4.0f);
        }
        if (((MorphInfo)ModMorphs.SHINOKUNI.get()).isActive(entity)) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 8.0f, ALL_TARGETS);
            targets.forEach(target -> AbilityDataCapability.get(entity).getEquippedAbility(ShinokuniAbility.INSTANCE).applyEffects(entity, (LivingEntity)target));
        } else {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 8.0f);
            targets.forEach(target -> target.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 5)));
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GASTANET.get(), (Entity)entity, mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }
}

