/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.giro;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;

public class PeepingMindAbility
extends PunchAbility {
    public static final AbilityCore<PeepingMindAbility> INSTANCE = new AbilityCore.Builder<PeepingMindAbility>("Peeping Mind", AbilityCategory.DEVIL_FRUITS, PeepingMindAbility::new).addDescriptionLine("The user looks into the enemies mind, learning about its abilities and where it lives", new Object[0]).build();

    public PeepingMindAbility(AbilityCore<PeepingMindAbility> core) {
        super(core);
        this.setMaxCooldown(10.0);
        this.setOnUseEvent(this::onUseEvent);
        this.onHitEntityEvent = this::onHitEntity;
    }

    private float onHitEntity(PlayerEntity entity, LivingEntity target) {
        IEntityStats statsData = EntityStatsCapability.get(target);
        IDevilFruit fruitData = DevilFruitCapability.get(target);
        IAbilityData abilityData = AbilityDataCapability.get(target);
        IHakiData hakiData = HakiDataCapability.get(target);
        ExtendedWorldData worldData = ExtendedWorldData.get((IWorld)target.field_70170_p);
        Crew crew = worldData.getCrewWithMember(target.func_110124_au());
        StringBuilder builder = new StringBuilder();
        builder.append("===============================================\n");
        builder.append("Name: " + target.func_145748_c_().getString() + "\n");
        builder.append("Faction: " + statsData.getFaction() + "\n");
        if (statsData.isMarine() || statsData.isRevolutionary()) {
            builder.append("Loyalty: " + statsData.getLoyalty() + "\n");
            builder.append("Rank: " + statsData.getMarineRank().getLocalizedName() + "\n");
        } else {
            builder.append("Crew: " + (crew != null ? crew.getName() : "None") + "\n");
        }
        builder.append("Race: " + statsData.getRace() + "\n");
        builder.append("Style: " + statsData.getFightingStyle() + "\n");
        builder.append("Doriki: " + statsData.getDoriki() + "\n");
        builder.append("Belly: " + statsData.getBelly() + "\n");
        builder.append("Extol: " + statsData.getExtol() + "\n");
        builder.append("Bounty: " + statsData.getBounty() + "\n");
        if (target.func_213374_dv().isPresent()) {
            builder.append("Spawn Point: " + target.func_213374_dv().isPresent() + "\n");
        }
        builder.append("Haki level: " + hakiData.getTotalHakiExp() / 6.0f + "\n");
        builder.append("Unlocked Abilities: \n");
        for (IAbility ability : abilityData.getEquippedAbilities()) {
            if (ability == null) continue;
            builder.append("- " + ability.getCore().getLocalizedName().toString() + " \n");
        }
        builder.append("===============================================");
        entity.func_145747_a((ITextComponent)new StringTextComponent(builder.toString()), Util.field_240973_b_);
        return 0.0f;
    }

    private boolean onUseEvent(PlayerEntity playerEntity) {
        return true;
    }
}

