/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoPistolAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SToggleDrumsOfLiberationSoundPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class GearFifthAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gear_fifth", new Pair[]{ImmutablePair.of((Object)"The absolute peak bringing joy and freedom to those around them.", null)});
    public static final int HOLD_TIME = 1200;
    private static final int MIN_COOLDOWN = 200;
    private static final float MAX_COOLDOWN = 800.0f;
    private static final Color COLOR = WyHelper.hexToRGB("#FFFFFF30");
    public static final AbilityCore<GearFifthAbility> INSTANCE = new AbilityCore.Builder<IAbility>("Gear Fifth", AbilityCategory.DEVIL_FRUITS, GearFifthAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f, 800.0f), ContinuousComponent.getTooltip(1200.0f), ChangeStatsComponent.getTooltip()).setUnlockCheck(GearFifthAbility::canUnlock).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setColor(COLOR).setRenderType(AbilityOverlay.RenderType.ENERGY).build();
    private static final AbilityAttributeModifier GRAVITY_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_GRAVITY_UUID, INSTANCE, "Nika Jump Modifier", (double)-0.02f, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    private boolean playJumpSound;

    public GearFifthAbility(AbilityCore core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.changeStatsComponent, this.skinOverlayComponent);
        this.changeStatsComponent.addAttributeModifier((Attribute)ForgeMod.ENTITY_GRAVITY.get(), (AttributeModifier)GRAVITY_MODIFIER);
        this.addCanUseCheck(GomuHelper.canUseGearCheck(INSTANCE));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
        this.skinOverlayComponent.showAll(entity);
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SToggleDrumsOfLiberationSoundPacket(entity, true), (Entity)entity);
        }
        this.playJumpSound = false;
        IAbilityData props = AbilityDataCapability.get(entity);
        GomuGomuNoPistolAbility pistol = props.getEquippedAbility(GomuGomuNoPistolAbility.INSTANCE);
        if (pistol != null) {
            pistol.switchFifthGear(entity);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_233570_aj_() && !this.playJumpSound) {
            this.playJumpSound = true;
        } else if (!entity.func_233570_aj_() && this.playJumpSound) {
            SoundEvent sfx = (SoundEvent)ModSounds.BOUNCE_1.get();
            if (entity.func_70681_au().nextBoolean()) {
                sfx = (SoundEvent)ModSounds.BOUNCE_2.get();
            }
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), sfx, SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 2.0f);
            this.playJumpSound = false;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        IAbilityData props;
        GomuGomuNoPistolAbility pistol;
        this.changeStatsComponent.removeModifiers(entity);
        this.skinOverlayComponent.hideAll(entity);
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SToggleDrumsOfLiberationSoundPacket(entity, false), (Entity)entity);
        }
        if ((pistol = (props = AbilityDataCapability.get(entity)).getEquippedAbility(GomuGomuNoPistolAbility.INSTANCE)) != null) {
            pistol.switchNoGear(entity);
        }
        float cooldown = Math.max(200.0f, this.continuousComponent.getContinueTime());
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private static boolean canUnlock(LivingEntity user) {
        return DevilFruitCapability.get(user).hasAwakenedFruit();
    }
}

