/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearFourthAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class GearFourthFlightAbility
extends PropelledFlightAbility {
    public static final AbilityCore<GearFourthFlightAbility> INSTANCE = new AbilityCore.Builder<GearFourthFlightAbility>("Gear Fourth Flight", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, GearFourthFlightAbility::new).setHidden().build();

    public GearFourthFlightAbility(AbilityCore<GearFourthFlightAbility> core) {
        super((AbilityCore<? extends PropelledFlightAbility>)core);
        super.addCanUseCheck(this::canFly);
        super.addDuringPassiveEvent(this::onDuringPassive);
    }

    private void onDuringPassive(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (super.canUse(entity).isSuccess()) {
            player.field_71075_bZ.field_75100_b = true;
        }
    }

    @Override
    public float getMaxSpeed(LivingEntity entity) {
        return 1.1f;
    }

    @Override
    protected float getAcceleration(LivingEntity entity) {
        return 0.01f;
    }

    @Override
    protected int getHeightDifference(LivingEntity entity) {
        return 40;
    }

    @Override
    protected Vector3d getMovementVector(LivingEntity entity) {
        boolean d1 = entity.func_233570_aj_();
        Vector3d lookVector = entity.func_70040_Z();
        double x = lookVector.field_72450_a * (double)this.speed * (1.0 - (double)d1) * (double)entity.field_191988_bg;
        double y = (double)d1 * 0.6 + lookVector.field_72448_b * (double)this.speed * (1.0 - (double)d1) * (double)entity.field_191988_bg + Math.cos((double)entity.field_70173_aa / (4.0 - (double)this.speed * 1.25)) / 5.0;
        double z = lookVector.field_72449_c * (double)this.speed * (1.0 - (double)d1) * (double)entity.field_191988_bg;
        return new Vector3d(x, y, z);
    }

    private AbilityUseResult canFly(LivingEntity entity, IAbility ability) {
        boolean isGearFourthActive;
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        GearFourthAbility gearFourthAbility = abilityDataProps.getEquippedAbility(GearFourthAbility.INSTANCE);
        boolean bl = isGearFourthActive = gearFourthAbility != null && gearFourthAbility.isContinuous();
        if (isGearFourthActive) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail(null);
    }

    @Override
    public boolean canRenderGauge(PlayerEntity entity) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        if (props == null) {
            return false;
        }
        GearFourthAbility gearFourthAbility = props.getEquippedAbility(GearFourthAbility.INSTANCE);
        boolean isGearFourthActive = gearFourthAbility != null && gearFourthAbility.isContinuous();
        return isGearFourthActive;
    }
}

