/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoBazookaAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoGatlingAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoPistolAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class GearThirdAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gear_third", new Pair[]{ImmutablePair.of((Object)"By blowing air and inflating their body, the user's attacks get bigger and gain incredible strength.", null)});
    private static final int HOLD_TIME = 400;
    private static final int MIN_COOLDOWN = 60;
    private static final float MAX_COOLDOWN = 400.0f;
    public static final AbilityCore<GearThirdAbility> INSTANCE = new AbilityCore.Builder<GearThirdAbility>("Gear Third", AbilityCategory.DEVIL_FRUITS, GearThirdAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f, 400.0f), ContinuousComponent.getTooltip(400.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);

    public GearThirdAbility(AbilityCore<GearThirdAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addCanUseCheck(GomuHelper.canUseGearCheck(INSTANCE));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 400.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        GomuGomuNoBazookaAbility bazooka;
        GomuGomuNoGatlingAbility gatling;
        IAbilityData props = AbilityDataCapability.get(entity);
        GomuGomuNoPistolAbility pistol = props.getEquippedAbility(GomuGomuNoPistolAbility.INSTANCE);
        if (pistol != null) {
            pistol.switchThirdGear(entity);
        }
        if ((gatling = props.getEquippedAbility(GomuGomuNoGatlingAbility.INSTANCE)) != null) {
            gatling.switchThirdGear(entity);
        }
        if ((bazooka = props.getEquippedAbility(GomuGomuNoBazookaAbility.INSTANCE)) != null) {
            bazooka.switchThirdGear(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        GomuGomuNoBazookaAbility bazooka;
        GomuGomuNoGatlingAbility gatling;
        IAbilityData props = AbilityDataCapability.get(entity);
        GomuGomuNoPistolAbility pistol = props.getEquippedAbility(GomuGomuNoPistolAbility.INSTANCE);
        if (pistol != null) {
            pistol.switchNoGear(entity);
        }
        if ((gatling = props.getEquippedAbility(GomuGomuNoGatlingAbility.INSTANCE)) != null) {
            gatling.switchNoGear(entity);
        }
        if ((bazooka = props.getEquippedAbility(GomuGomuNoBazookaAbility.INSTANCE)) != null) {
            bazooka.switchNoGear(entity);
        }
        float cooldown = Math.max(60.0f, this.continuousComponent.getContinueTime());
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

