/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import xyz.pixelatedw.mineminenomi.abilities.LogiaInvulnerabilityAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class GoroLogiaAbility
extends LogiaInvulnerabilityAbility {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/logia_invulnerability_goro.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/alts/logia_invulnerability_goro.png");
    public static final AbilityCore<GoroLogiaAbility> INSTANCE = new AbilityCore.Builder<IAbility>("Logia Invulnerability Goro", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, GoroLogiaAbility::new).addDescriptionLine(LogiaInvulnerabilityAbility.DESCRIPTION).setIcon(DEFAULT_ICON).build();

    public GoroLogiaAbility(AbilityCore<GoroLogiaAbility> ability) {
        super(ability, null, (Supplier<ParticleEffect<?>>)ModParticleEffects.GORO_LOGIA);
        this.onLogiaEffect = this::sideEffect;
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, PassiveAbility2 ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
    }

    @Override
    public boolean isDamageTaken(LivingEntity entity, DamageSource source, float amount) {
        if (source instanceof AbilityDamageSource && ((AbilityDamageSource)source).getElement() == SourceElement.RUBBER) {
            return true;
        }
        return super.isDamageTaken(entity, source, amount);
    }

    public boolean sideEffect(LivingEntity target, LivingEntity attacker) {
        boolean attackerHasGomu;
        IDevilFruit props = DevilFruitCapability.get(attacker);
        boolean bl = attackerHasGomu = props.hasDevilFruit(ModAbilities.GOMU_GOMU_NO_MI) && attacker.func_184614_ca().func_190926_b();
        if (!attackerHasGomu) {
            attacker.func_70097_a((DamageSource)AbilityDamageSource.causeAbilityDamage(target, this).setSourceElement(SourceElement.LIGHTNING), 5.0f);
            return false;
        }
        return true;
    }
}

