/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.goro.VoltAmaruAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class VoltAmaruFlightAbility
extends PropelledFlightAbility {
    public static final AbilityCore<VoltAmaruFlightAbility> INSTANCE = new AbilityCore.Builder<VoltAmaruFlightAbility>("Volt Amaru Flight", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, VoltAmaruFlightAbility::new).build();

    public VoltAmaruFlightAbility(AbilityCore<VoltAmaruFlightAbility> core) {
        super((AbilityCore<? extends PropelledFlightAbility>)core);
        super.addCanUseCheck(this::canFly);
        super.addDuringPassiveEvent(this::onDuringPassive);
    }

    private void onDuringPassive(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        if (!this.isRecovering) {
            PlayerEntity player = (PlayerEntity)entity;
            double difference = DevilFruitHelper.getDifferenceToFloor((Entity)entity);
            if (difference < 5.0 && player.field_71075_bZ.field_75100_b) {
                AbilityHelper.setDeltaMovement((Entity)entity, entity.func_213322_ci().func_72441_c(0.0, 1.0, 0.0).func_216372_d(1.0, 0.25, 1.0));
            }
        }
    }

    @Override
    public float getMaxSpeed(LivingEntity entity) {
        return entity.func_70051_ag() ? 2.1f : 1.1f;
    }

    @Override
    protected float getAcceleration(LivingEntity entity) {
        return 0.015f;
    }

    @Override
    protected int getHeightDifference(LivingEntity entity) {
        return 36;
    }

    private AbilityUseResult canFly(LivingEntity entity, IAbility ability) {
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        VoltAmaruAbility voltAmaruAbility = abilityDataProps.getEquippedAbility(VoltAmaruAbility.INSTANCE);
        if (voltAmaruAbility != null && voltAmaruAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail(null);
    }
}

