/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gura;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gura.GekishinProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.gura.AirCrackParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class GekishinAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gekishin", new Pair[]{ImmutablePair.of((Object)"The user 'cracks' the air, launching a single concentrated shockwave forward which send blocks flying and deals damage to all enemies in its path", null), ImmutablePair.of((Object)"The user 'cracks' the air on their sides, launching two smaller shockwaves which send blocks flying and deals damage to all enemies in their path", null)});
    private static final TranslationTextComponent GEKISHIN_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gekishin", "Gekishin"));
    private static final TranslationTextComponent KAISHIN_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.kaishin", "Kaishin"));
    private static final ResourceLocation GEKISHIN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gekishin.png");
    private static final ResourceLocation KAISHIN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/kaishin.png");
    private static final AirCrackParticleEffect PARTICLES = new AirCrackParticleEffect();
    private static final float GEKISHIN_COOLDOWN = 240.0f;
    private static final float GEKISHIN_CHARGE_TIME = 20.0f;
    private static final float KAISHIN_COOLDOWN = 480.0f;
    private static final float KAISHIN_CHARGE_TIME = 40.0f;
    public static final AbilityCore<GekishinAbility> INSTANCE = new AbilityCore.Builder<GekishinAbility>("Gekishin", AbilityCategory.DEVIL_FRUITS, GekishinAbility::new).addAdvancedDescriptionLine((e, a) -> GEKISHIN_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip(240.0f), ChargeComponent.getTooltip(20.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> KAISHIN_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip(480.0f), ChargeComponent.getTooltip(40.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE).setSourceElement(SourceElement.SHOCKWAVE).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addEndEvent(this::onChargeEnd);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.GEKISHIN).addChangeModeEvent(this::onAltModeChange);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public GekishinAbility(AbilityCore<GekishinAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.altModeComponent, this.animationComponent, this.projectileComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.KAISHIN) {
            this.chargeComponent.startCharging(entity, 40.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.GEKISHIN) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.KAISHIN);
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.altModeComponent.getCurrentMode() == Mode.GEKISHIN) {
            EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, 1.5);
            PARTICLES.spawn(entity.field_70170_p, trace.func_216347_e().func_82615_a(), entity.func_226278_cu_() + 0.5, trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
            this.projectileComponent.shoot(entity, 3.0f, 1.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.KAISHIN) {
            Vector3d v1 = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0).func_178787_e(entity.func_70040_Z().func_186678_a(2.5).func_178785_b(180.0f));
            Vector3d v2 = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0).func_178787_e(entity.func_70040_Z().func_186678_a(2.5).func_178785_b(-180.0f));
            PARTICLES.spawn(entity.field_70170_p, v1.func_82615_a(), entity.func_226278_cu_() + 0.5, v1.func_82616_c(), 0.0, 0.0, 0.0);
            PARTICLES.spawn(entity.field_70170_p, v2.func_82615_a(), entity.func_226278_cu_() + 0.5, v2.func_82616_c(), 0.0, 0.0, 0.0);
            double range = 8.0;
            List<Entity> list = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, range, ModEntityPredicates.getEnemyFactions(entity), Entity.class);
            for (Entity target : list) {
                if (target instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)target).getDamage() < 20.0f && ((AbilityProjectileEntity)target).isPhysical()) {
                    target.func_70106_y();
                }
                if (!(target instanceof LivingEntity)) continue;
                Vector3d speed = target.func_70040_Z().func_216372_d(3.0, 2.0, 3.0);
                AbilityHelper.setDeltaMovement(target, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
                target.field_70143_R = 0.0f;
            }
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 0.5f, 1.0f);
            GekishinProjectile p1 = (GekishinProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
            p1.setMaxLife((int)((float)p1.getMaxLife() * 0.5f));
            entity.field_70170_p.func_217376_c((Entity)p1);
            p1.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z + 90.0f, 0.0f, 1.75f, 1.0f);
            GekishinProjectile p2 = (GekishinProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
            p2.setMaxLife((int)((float)p2.getMaxLife() * 0.5f));
            entity.field_70170_p.func_217376_c((Entity)p2);
            p2.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z - 90.0f, 0.0f, 1.75f, 1.0f);
        }
        this.animationComponent.stop(entity);
        if (this.altModeComponent.getCurrentMode() == Mode.KAISHIN) {
            this.cooldownComponent.startCooldown(entity, 480.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.GEKISHIN) {
            this.cooldownComponent.startCooldown(entity, 240.0f);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.KAISHIN) {
            super.setDisplayName((ITextComponent)KAISHIN_NAME);
            super.setDisplayIcon(KAISHIN_ICON);
        } else if (mode == Mode.GEKISHIN) {
            super.setDisplayName((ITextComponent)GEKISHIN_NAME);
            super.setDisplayIcon(GEKISHIN_ICON);
        }
    }

    private GekishinProjectile createProjectile(LivingEntity entity) {
        GekishinProjectile proj = new GekishinProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    public static enum Mode {
        GEKISHIN,
        KAISHIN;

    }
}

