/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gura;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class ShingenNoIchigekiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "shingen_no_ichigeki", new Pair[]{ImmutablePair.of((Object)"The user focuses vibrations around their fist in an spherical bubble, releasing when hitting an enemy.", null), ImmutablePair.of((Object)"The user slams their fist on the ground pushing all nearby enemies.", null)});
    private static final TranslationTextComponent SINGLE_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.shingen_no_ichigeki", "Shingen no Ichigeki"));
    private static final TranslationTextComponent CROWD_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.shingen_no_ichigeki_crowd", "Shingen no Ichigeki: Crowd"));
    private static final ResourceLocation SHINGEN_NO_ICHIGEKI_SINGLE_ICON = new ResourceLocation("mineminenomi", "textures/abilities/shingen_no_ichigeki.png");
    private static final ResourceLocation SHINGEN_NO_ICHIGEKI_CROWD_ICON = new ResourceLocation("mineminenomi", "textures/abilities/shingen_no_ichigeki_crowd.png");
    private static final float COOLDOWN = 200.0f;
    private static final float DAMAGE = 40.0f;
    public static final AbilityCore<ShingenNoIchigekiAbility> INSTANCE = new AbilityCore.Builder<ShingenNoIchigekiAbility>("Shingen no Ichigeki", AbilityCategory.DEVIL_FRUITS, ShingenNoIchigekiAbility::new).addDescriptionLine((e, a) -> SINGLE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip(200.0f), DealDamageComponent.getTooltip(40.0f)).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> CROWD_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip(200.0f), DealDamageComponent.getTooltip(5.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setSourceElement(SourceElement.SHOCKWAVE).build();
    private static final AbilityAttributeModifier PUNCH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("65b21fdd-0490-49fb-9138-9627bc8bccf9"), INSTANCE, "Shingeki no Ichi Punch Damage Modifier", 40.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onContinuityStart).addTickEvent(this::duringContinuityEvent).addEndEvent(this::onContinuityEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(this::onHitTrigger).addTryHitEvent(this::tryHitEvent);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.SINGLE).addChangeModeEvent(this::onAltModeChange);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent(this);
    private boolean markForStopping = false;

    public ShingenNoIchigekiAbility(AbilityCore<ShingenNoIchigekiAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.hitTriggerComponent, this.altModeComponent, this.dealDamageComponent, this.statsComponent);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)PUNCH_MODIFIER, e -> this.continuousComponent.isContinuous());
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.SINGLE) {
            this.continuousComponent.triggerContinuity(entity);
        } else if (this.altModeComponent.getCurrentMode() == Mode.CROWD) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 3.0f);
            explosion.setStaticDamage(5.0f);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(3));
            explosion.doExplosion();
            List<LivingEntity> targets = WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 10.0, ModEntityPredicates.getEnemyFactions(entity));
            targets.remove(entity);
            for (LivingEntity target : targets) {
                if (!this.dealDamageComponent.hurtTarget(entity, target, 5.0f)) continue;
                Vector3d dirVec = entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_216372_d(4.0, 1.0, 4.0);
                AbilityHelper.setDeltaMovement((Entity)target, -dirVec.field_72450_a, 0.5 + dirVec.field_72448_b, -dirVec.field_72449_c);
            }
            this.cooldownComponent.startCooldown(entity, 200.0f);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.markForStopping = false;
        this.statsComponent.applyModifiers(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.markForStopping) {
            this.continuousComponent.stopContinuity(entity);
            this.markForStopping = false;
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.statsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous() || !entity.func_184614_ca().func_190926_b()) {
            return HitTriggerComponent.HitResult.PASS;
        }
        return HitTriggerComponent.HitResult.HIT;
    }

    private boolean onHitTrigger(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        source.setPiercing(0.75f).bypassLogia();
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 2.0f);
        explosion.setStaticDamage(10.0f);
        explosion.setDestroyBlocks(false);
        explosion.setDamageEntities(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
        explosion.doExplosion();
        Vector3d dirVec = entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_216372_d(2.0, 1.0, 2.0);
        AbilityHelper.setDeltaMovement((Entity)target, -dirVec.field_72450_a, 0.5 + dirVec.field_72448_b, -dirVec.field_72449_c);
        target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 100, 0, false, false));
        this.markForStopping = true;
        return true;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.SINGLE) {
            super.setDisplayIcon(SHINGEN_NO_ICHIGEKI_SINGLE_ICON);
        } else if (mode == Mode.CROWD) {
            super.setDisplayIcon(SHINGEN_NO_ICHIGEKI_CROWD_ICON);
        }
    }

    public static enum Mode {
        SINGLE,
        CROWD;

    }
}

