/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gura;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TenchiMeidoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tenchi_meido", new Pair[]{ImmutablePair.of((Object)"The user grabs the air and pulls it downwards, after which all of the opponents are tossed into the air.", null)});
    private static final int COOLDOWN = 400;
    private static final int CHARGE_TIME = 20;
    private static final int RANGE = 26;
    public static final AbilityCore<TenchiMeidoAbility> INSTANCE = new AbilityCore.Builder<TenchiMeidoAbility>("Tenchi Meido", AbilityCategory.DEVIL_FRUITS, TenchiMeidoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), ChargeComponent.getTooltip(20.0f), RangeComponent.getTooltip(26.0f, RangeComponent.RangeType.AOE)).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(40);

    public TenchiMeidoAbility(AbilityCore<TenchiMeidoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.rangeComponent);
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 20.0f);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
            int range = (int)Math.ceil(26.0);
            for (int x = -range; x < range; ++x) {
                for (int z = -range; z < range; ++z) {
                    if (entity.func_70681_au().nextInt(100) != 0) continue;
                    double posX = entity.func_226277_ct_() + (double)x;
                    double posY = entity.func_226278_cu_() - 1.0;
                    double posZ = entity.func_226281_cx_() + (double)z;
                    Vector3d pos = new Vector3d(posX, posY, posZ);
                    positions.add(pos);
                }
            }
            if (positions.size() > 0) {
                this.details.setVecPositions(positions);
            }
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, 0.0, 0.0, 0.0, this.details);
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0));
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 26.0f);
        for (LivingEntity target : targets) {
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 10, 0, false, false));
        }
    }

    private void endChargeEvent(LivingEntity player, IAbility ability) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(player, 26.0f);
        for (LivingEntity target : targets) {
            Vector3d dirVec = player.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_216372_d(15.0, 1.0, 15.0);
            AbilityHelper.setDeltaMovement((Entity)target, -dirVec.field_72450_a, 3.0, -dirVec.field_72449_c);
        }
        this.cooldownComponent.startCooldown(player, 400.0f);
    }
}

