/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.awt.Color;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiImbuingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class BusoshokuHakiHardeningAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "busoshoku_haki_hardening", new Pair[]{ImmutablePair.of((Object)"Covers the fist of the user in Armament haki, making their physical attacks more powerful and being able to damage Logia users.", null)});
    public static final AbilityCore<BusoshokuHakiHardeningAbility> INSTANCE = new AbilityCore.Builder<BusoshokuHakiHardeningAbility>("Busoshoku Haki: Hardening", AbilityCategory.HAKI, BusoshokuHakiHardeningAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(BusoshokuHakiHardeningAbility::canUnlock).setSourceType(SourceType.FIST).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.BUSOSHOKU_HAKI_ARM).setOverlayPart(AbilityOverlay.OverlayPart.LIMB).setColor(new Color(255, 255, 255, 191)).build();
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.BODY_BUSOSHOKU_HAKI, new AbilityPool2[0]);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);

    public BusoshokuHakiHardeningAbility(AbilityCore<BusoshokuHakiHardeningAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.continuousComponent.addStartEvent(100, this::onContinuityStart).addTickEvent(100, this::onContinuityTick).addEndEvent(100, this::onContinuityEnd);
        super.addComponents(this.poolComponent, this.skinOverlayComponent);
        super.addCanUseCheck(HakiHelper::canEnableHaki);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.BUSOSHOKU_HAKI_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(entity, 0);
        if (isOnMaxOveruse) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        source.bypassLogia();
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return -1;
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public float getPunchCooldown() {
        return 0.0f;
    }

    private static boolean canUnlock(LivingEntity user) {
        IAbilityData abilityProps = AbilityDataCapability.get(user);
        IHakiData props = HakiDataCapability.get(user);
        IEntityStats statsProps = EntityStatsCapability.get(user);
        boolean hasImbuingUnlocked = abilityProps.hasUnlockedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
        return statsProps.getDoriki() > 4000.0 && (double)props.getBusoshokuHakiExp() > HakiHelper.getBusoshokuHardeningExpNeeded(user) || hasImbuingUnlocked;
    }
}

