/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.events.ability.HakiKnockoutEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.haki.HaoshokuHakiParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HaoshokuHakiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "haoshoku_haki", new Pair[]{ImmutablePair.of((Object)"A burst of the unique Conqueror's haki, that knocks out enemies that are weaker than the user.", null)});
    private static final List<Supplier<Effect>> REDUCIBLE_EFFECTS = Arrays.asList(ModEffects.CANDLE_LOCK, ModEffects.LOVESTRUCK, ModEffects.FROZEN, ModEffects.CANDY_STUCK);
    private static final ResourceLocation[] ICONS = new ResourceLocation[]{new ResourceLocation("mineminenomi", "textures/abilities/haoshoku_haki_0.png"), new ResourceLocation("mineminenomi", "textures/abilities/haoshoku_haki_1.png"), new ResourceLocation("mineminenomi", "textures/abilities/haoshoku_haki_2.png")};
    public static final AbilityCore<HaoshokuHakiAbility> INSTANCE = new AbilityCore.Builder<HaoshokuHakiAbility>("Haoshoku Haki", AbilityCategory.HAKI, HaoshokuHakiAbility::new).setIcon(ICONS[0]).addDescriptionLine(DESCRIPTION).setUnlockCheck(HaoshokuHakiAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private HaoshokuHakiParticleEffect.Details particleDetails = new HaoshokuHakiParticleEffect.Details();
    private LightningDischargeEntity discharge;
    private Color color = new Color(0xFF0000);
    private int burstSize = 0;
    private int radius = 0;
    private int unconsciousTimer = 0;
    private int haoMastery = 0;
    private final Interval effectInterval = new Interval(20);

    public HaoshokuHakiAbility(AbilityCore<HaoshokuHakiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addCanUseCheck(HakiHelper::canEnableHaki);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.effectInterval.restartIntervalToZero();
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 4.0f, 1.0f);
        IHakiData hakiProps = HakiDataCapability.get(entity);
        float haoLevel = hakiProps.getTotalHakiExp() / 100.0f;
        if (haoLevel <= 1.0f) {
            this.radius = 10;
            this.unconsciousTimer = 20;
            this.burstSize = 3;
            this.haoMastery = 0;
        } else if (haoLevel > 1.0f && haoLevel <= 1.75f) {
            this.radius = 25;
            this.unconsciousTimer = 40;
            this.burstSize = 5;
            this.haoMastery = 1;
        } else if (haoLevel > 1.75f) {
            this.radius = 40;
            this.unconsciousTimer = 50;
            this.burstSize = 10;
            this.haoMastery = 2;
        }
        this.color = new Color(HakiHelper.getHaoshokuColour(entity));
        this.discharge = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 1.5, entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        this.discharge.setAliveTicks(-1);
        this.discharge.setUpdateRate(8);
        this.discharge.setLightningLength(this.radius * 2);
        this.discharge.setColor(new Color(0, 0, 0, 100));
        this.discharge.setOutlineColor(this.color);
        this.discharge.setRenderTransparent();
        this.discharge.setDetails(16);
        int density = this.haoMastery == 2 ? 32 : 16;
        this.discharge.setDensity(density);
        this.discharge.setSize(1.0f);
        this.discharge.setSkipSegments(1);
        if (this.haoMastery == 0) {
            this.discharge.setSplit();
        }
        entity.field_70170_p.func_217376_c((Entity)this.discharge);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int continueTime = (int)this.continuousComponent.getContinueTime();
        IHakiData hakiProps = HakiDataCapability.get(entity);
        if (this.effectInterval.canTick()) {
            for (EffectInstance instance : entity.func_70651_bq()) {
                boolean isReducible = false;
                for (Supplier<Effect> reducible : REDUCIBLE_EFFECTS) {
                    if (reducible.get() != instance.func_188419_a()) continue;
                    isReducible = true;
                    break;
                }
                if (!isReducible) continue;
                ((EffectInstanceMixin)instance).setDuration(instance.func_76459_b() - 100);
                WyHelper.sendApplyEffectToAllNearby(entity, entity.func_213303_ch(), 100, instance);
            }
        }
        if (continueTime % 5 == 0) {
            this.particleDetails.setSize(this.burstSize);
            this.particleDetails.setColor(this.color.getRGB());
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.HAOSHOKU_HAKI.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), this.particleDetails);
            this.discharge.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_());
        }
        if (continueTime % 10 == 0) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
        }
        if (continueTime % 20 == 0) {
            boolean isOnMaxOveruse;
            hakiProps.alterHakiOveruse(200);
            this.knockoutNearbyEnemies(entity);
            boolean bl = isOnMaxOveruse = !HakiHelper.canEnableHaki(entity);
            if (isOnMaxOveruse) {
                this.continuousComponent.stopContinuity(entity);
                return;
            }
        }
        if (continueTime % 100 == 0) {
            if (this.radius == 25) {
                this.destroyNearbyBlocks(entity, 1.0f, 3);
            } else if (this.radius > 25) {
                this.destroyNearbyBlocks(entity, 2.0f, 5);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        float cooldown = this.continuousComponent.getContinueTime() / 2.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
        if (this.discharge != null) {
            this.discharge.setAliveTicks(30);
        }
    }

    private void knockoutNearbyEnemies(LivingEntity user) {
        List<LivingEntity> targets = WyHelper.getNearbyLiving(user.func_213303_ch(), (IWorld)user.field_70170_p, this.radius, ModEntityPredicates.getEnemyFactions(user));
        IHakiData hakiProps = HakiDataCapability.get(user);
        float haoLevel = hakiProps.getTotalHakiExp() / 100.0f;
        for (LivingEntity target : targets) {
            double targetHaoLevel = HakiDataCapability.get(target).getTotalHakiExp() / 100.0f;
            if (targetHaoLevel + 0.5 >= (double)haoLevel) continue;
            if (this.haoMastery > 0) {
                HakiKnockoutEvent.Post postEvent = null;
                if (target.func_70644_a((Effect)ModEffects.UNCONSCIOUS.get())) {
                    EffectInstance instance1 = target.func_70660_b((Effect)ModEffects.UNCONSCIOUS.get());
                    int timer = instance1.func_76459_b() + this.unconsciousTimer;
                    HakiKnockoutEvent.Pre event = new HakiKnockoutEvent.Pre(target, user, true, timer);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    ((EffectInstanceMixin)instance1).setDuration(timer);
                    postEvent = new HakiKnockoutEvent.Post(target, user, true, timer);
                } else {
                    EffectInstance instance = new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), this.unconsciousTimer, 1, false, false);
                    HakiKnockoutEvent.Pre event = new HakiKnockoutEvent.Pre(target, user, false, this.unconsciousTimer);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    target.func_195064_c(instance);
                    postEvent = new HakiKnockoutEvent.Post(target, user, false, this.unconsciousTimer);
                }
                MinecraftForge.EVENT_BUS.post((Event)postEvent);
                continue;
            }
            target.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
        }
    }

    private void destroyNearbyBlocks(LivingEntity entity, float density, int range) {
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        float x0 = (float)entity.func_226277_ct_();
        float z0 = (float)entity.func_226281_cx_();
        int i = 0;
        int rho = (int)((float)(-range) * density);
        while ((double)rho <= Math.PI * (double)density) {
            int phi = 0;
            while ((float)phi <= (float)range * density) {
                if (++i % 5 == 0) {
                    float phi1 = (float)phi / density;
                    float rho1 = (float)rho / density;
                    for (int r = 0; r <= 20; r += 5) {
                        float x = (float)((double)x0 + (double)r * Math.cos(phi1) * Math.cos(rho1) + WyHelper.randomWithRange(-3, 3));
                        float y = (float)(entity.func_226278_cu_() - 2.0 + (double)r * Math.sin(phi1));
                        float z = (float)((double)z0 + (double)r * Math.cos(phi1) * Math.sin(rho1) + WyHelper.randomWithRange(-3, 3));
                        mutpos.func_189532_c((double)x, (double)y, (double)z);
                        BlockState state = entity.field_70170_p.func_180495_p((BlockPos)mutpos);
                        BlockState stateAbove = entity.field_70170_p.func_180495_p(mutpos.func_177984_a());
                        if (stateAbove.func_185904_a().func_76220_a() || mutpos.func_218141_a((Vector3i)entity.func_233580_cy_(), 3.0) || !AbilityHelper.placeBlockIfAllowed(entity, (BlockPos)mutpos, Blocks.field_150350_a.func_176223_P(), DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                        entity.field_70170_p.func_217379_c(2001, (BlockPos)mutpos, Block.func_196246_j((BlockState)state));
                    }
                }
                ++phi;
            }
            ++rho;
        }
    }

    private static boolean canUnlock(LivingEntity user) {
        if (CommonConfig.INSTANCE.getHaoshokuUnlockLogic() == CommonConfig.HaoshokuUnlockLogic.NONE) {
            return false;
        }
        if (user instanceof PlayerEntity) {
            boolean flag;
            if (CommonConfig.INSTANCE.isHaoshokuUnlockLogicChanceBased() && (flag = HakiHelper.isHaoshokuBorn((PlayerEntity)user))) {
                return true;
            }
            if (CommonConfig.INSTANCE.isHaoshokuUnlockLogicExpBased()) {
                IHakiData props = HakiDataCapability.get(user);
                boolean hasExp = (double)props.getTotalHakiExp() >= WyHelper.percentage(80.0, props.getMaxHakiExp());
                boolean hasHakiAbilities = false;
                int i = 0;
                for (AbilityCore core : ModAbilities.HAKI_ABILITIES) {
                    if (i >= 2) {
                        hasHakiAbilities = true;
                        break;
                    }
                    if (core == INSTANCE || !AbilityDataCapability.get(user).hasUnlockedAbility(core)) continue;
                    ++i;
                }
                return hasExp && hasHakiAbilities;
            }
        }
        return false;
    }

    @Override
    public ResourceLocation getIcon(LivingEntity player) {
        float haoLevel = HakiDataCapability.get(player).getTotalHakiExp() / 100.0f;
        int level = 0;
        if (haoLevel > 1.0f && haoLevel <= 1.75f) {
            level = 1;
        } else if (haoLevel > 1.75f) {
            level = 2;
        }
        return ICONS[level];
    }
}

