/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.awt.Color;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.haki.HaoshokuHakiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HaoshokuHakiInfusionAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "haoshoku_haki_infusion", new Pair[]{ImmutablePair.of((Object)"Allows the user to infuse their haoshoku haki into whatever weapon they're holding.", null)});
    public static final AbilityCore<HaoshokuHakiInfusionAbility> INSTANCE = new AbilityCore.Builder<HaoshokuHakiInfusionAbility>("Haoshoku Haki: Infusion", AbilityCategory.HAKI, HaoshokuHakiInfusionAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(HaoshokuHakiInfusionAbility::canUnlock).setSourceType(SourceType.FIST).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.LIMB).setColor(new Color(255, 0, 0, 50)).build();
    private static final UUID STRENGTH_UUID = UUID.fromString("46383f90-63d5-4cfb-8df7-f93db7d5b84b");
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.ADVANCED_HAOSHOKU_HAKI, new AbilityPool2[0]);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);

    public HaoshokuHakiInfusionAbility(AbilityCore<HaoshokuHakiInfusionAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.continuousComponent.addStartEvent(100, this::onContinuityStart).addTickEvent(100, this::onContinuityTick).addEndEvent(100, this::onContinuityEnd);
        super.addComponents(this.poolComponent, this.skinOverlayComponent);
        super.addCanUseCheck(HakiHelper::canEnableHaki);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        Color clientRGB = WyHelper.intToRGB(HakiHelper.getHaoshokuColour(entity), 50);
        AbilityOverlay overlay = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.LIMB).setColor(clientRGB).build();
        this.skinOverlayComponent.show(entity, overlay);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(entity, 3);
        if (isOnMaxOveruse) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        source.bypassLogia();
        if (entity.func_70681_au().nextInt(10) < 1) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.7f);
        }
        Color clientRGB = WyHelper.intToRGB(HakiHelper.getHaoshokuColour(entity), 50);
        LightningDischargeEntity discharge = new LightningDischargeEntity((Entity)target, target.func_226277_ct_(), target.func_226278_cu_() + 1.5, target.func_226281_cx_(), target.field_70177_z, target.field_70125_A);
        discharge.setAliveTicks(15);
        discharge.setLightningLength(6.0f);
        discharge.setColor(new Color(0, 0, 0, 100));
        discharge.setOutlineColor(clientRGB);
        discharge.setRenderTransparent();
        discharge.setDetails(4);
        discharge.setDensity(4);
        discharge.setSize(1.0f);
        discharge.setSkipSegments(1);
        entity.field_70170_p.func_217376_c((Entity)discharge);
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    @Override
    public int getUseLimit() {
        return -1;
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public float getPunchCooldown() {
        return 0.0f;
    }

    public static double getDamageBoost(LivingEntity entity, float originalAmount) {
        IEntityStats props = EntityStatsCapability.get(entity);
        IHakiData hakiProps = HakiDataCapability.get(entity);
        double dorikiMultiplier = props.getDoriki() / (double)CommonConfig.INSTANCE.getDorikiLimit();
        float hakiMultiplier = hakiProps.getBusoshokuHakiExp() / (float)CommonConfig.INSTANCE.getHakiExpLimit();
        return 10.0 + (double)originalAmount / 100.0 * 70.0 * (0.1 * dorikiMultiplier + 0.9 * (double)hakiMultiplier);
    }

    private AbilityAttributeModifier getEntryAttackDamage(double amount) {
        return new AbilityAttributeModifier(STRENGTH_UUID, INSTANCE, "Haoshoku Haki Infusion Attack Damage Modifier", amount, AttributeModifier.Operation.ADDITION);
    }

    private static boolean canUnlock(LivingEntity user) {
        IHakiData props = HakiDataCapability.get(user);
        boolean hasHakiAbilities = AbilityDataCapability.get(user).hasUnlockedAbility(HaoshokuHakiAbility.INSTANCE);
        return props.getTotalHakiExp() >= props.getMaxHakiExp() * 0.85f && hasHakiAbilities;
    }
}

