/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hana;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.hana.DosFleurClutchAbility;
import xyz.pixelatedw.mineminenomi.abilities.hana.SeisFleurSlapAbility;
import xyz.pixelatedw.mineminenomi.abilities.hana.SeisFleurTwistAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class MilFleurAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mil_fleur", new Pair[]{ImmutablePair.of((Object)"While active all the other abilities of this fruit will transform, either allowing for area of effects or bigger and better versions of themselves.", null)});
    private static final int HOLD_TIME = 600;
    private static final int MIN_COOLDOWN = 100;
    private static final float MAX_COOLDOWN = 400.0f;
    public static final AbilityCore<MilFleurAbility> INSTANCE = new AbilityCore.Builder<MilFleurAbility>("Mil Fleur", AbilityCategory.DEVIL_FRUITS, MilFleurAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 400.0f), ContinuousComponent.getTooltip(600.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);

    public MilFleurAbility(AbilityCore<MilFleurAbility> ability) {
        super(ability);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 600.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        SeisFleurTwistAbility seisFleurTwist;
        SeisFleurSlapAbility seisFleurSlap;
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        DosFleurClutchAbility dosFleurClutch = abilityProps.getEquippedAbility(DosFleurClutchAbility.INSTANCE);
        if (dosFleurClutch != null) {
            dosFleurClutch.switchMilMode(entity);
        }
        if ((seisFleurSlap = abilityProps.getEquippedAbility(SeisFleurSlapAbility.INSTANCE)) != null) {
            seisFleurSlap.switchMilMode(entity);
        }
        if ((seisFleurTwist = abilityProps.getEquippedAbility(SeisFleurTwistAbility.INSTANCE)) != null) {
            seisFleurTwist.switchMilMode(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        SeisFleurTwistAbility seisFleurTwist;
        SeisFleurSlapAbility seisFleurSlap;
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        DosFleurClutchAbility dosFleur = abilityProps.getEquippedAbility(DosFleurClutchAbility.INSTANCE);
        if (dosFleur != null) {
            dosFleur.switchNormalMode(entity);
        }
        if ((seisFleurSlap = abilityProps.getEquippedAbility(SeisFleurSlapAbility.INSTANCE)) != null) {
            seisFleurSlap.switchNormalMode(entity);
        }
        if ((seisFleurTwist = abilityProps.getEquippedAbility(SeisFleurTwistAbility.INSTANCE)) != null) {
            seisFleurTwist.switchNormalMode(entity);
        }
        float cooldown = Math.max(100.0f, 400.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    public static enum Mode {
        NORMAL,
        MIL_FLEUR;

    }
}

