/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hie;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class IceAgeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ice_age", new Pair[]{ImmutablePair.of((Object)"Freezes a large area around the user and everyone inside of it", null)});
    private static final int CHARGE_TIME = 100;
    private static final int MIN_COOLDOWN = 200;
    private static final int MAX_COOLDOWN = 300;
    private static final int ICE_RANGE = 64;
    private static final float ENTITY_FREEZE_RANGE = 1.5f;
    public static final AbilityCore<IceAgeAbility> INSTANCE = new AbilityCore.Builder<IceAgeAbility>("Ice Age", AbilityCategory.DEVIL_FRUITS, IceAgeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f, 300.0f), ChargeComponent.getTooltip(100.0f), RangeComponent.getTooltip(64.0f, RangeComponent.RangeType.AOE)).setSourceElement(SourceElement.ICE).build();
    private static final BlockProtectionRule PROTECTION_RULE = new BlockProtectionRule.Builder(DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID).addReplaceRules((world, pos, state) -> {
        if (state.func_177230_c().equals(Blocks.field_150433_aE) && (Integer)state.func_177229_b((Property)SnowBlock.field_176315_a) > 5) {
            world.func_180501_a(pos, Blocks.field_205164_gk.func_176223_P(), 3);
            return true;
        }
        return false;
    }).build();
    private final BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> (double)comp.getChargePercentage() > 0.5).addStartEvent(100, this::startChargeEvent).addTickEvent(100, this::duringChargeEvent).addEndEvent(100, this::stopChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);

    public IceAgeAbility(AbilityCore<IceAgeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.rangeComponent, this.hitTrackerComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 100.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.hitTrackerComponent.clearHits();
        this.blockPlacingHelper.clearList();
        double radiusXZ = 64.0;
        double radiusY = 9.0;
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.ICE_AGE_SFX.get(), SoundCategory.PLAYERS, 10.0f, 1.0f);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.ICE_AGE.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        for (double y = -radiusY; y < radiusY; y += 1.0) {
            for (double x = -radiusXZ; x < radiusXZ; x += 1.0) {
                for (double z = -radiusXZ; z < radiusXZ; z += 1.0) {
                    double posZ;
                    double posY;
                    double posX = entity.func_226277_ct_() + x + (x < -WyHelper.randomWithRange((int)(radiusXZ * 0.5), (int)(radiusXZ * 0.75)) || x > WyHelper.randomWithRange((int)(radiusXZ * 0.5), (int)(radiusXZ * 0.75)) ? WyHelper.randomWithRange(-5, 5) : 0.0);
                    if (!AbilityHelper.canPlaceBlock(entity.field_70170_p, posX, posY = entity.func_226278_cu_() + y, posZ = entity.func_226281_cx_() + z + (z < -WyHelper.randomWithRange((int)(radiusXZ * 0.5), (int)(radiusXZ * 0.75)) || z > WyHelper.randomWithRange((int)(radiusXZ * 0.5), (int)(radiusXZ * 0.75)) ? WyHelper.randomWithRange(-5, 5) : 0.0), Blocks.field_205164_gk.func_176223_P(), 3, PROTECTION_RULE)) continue;
                    mutpos.func_189532_c(posX, posY, posZ);
                    this.blockPlacingHelper.addBlockPos((BlockPos)mutpos, (int)(x * x + y * y + z * z));
                }
            }
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
        Set<BlockPos> blockList = this.blockPlacingHelper.getBlockList();
        int finished = blockList.size() / 100;
        Iterator<BlockPos> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = iterator.next();
            if (finished-- < 0) break;
            AbilityHelper.placeBlockIfAllowed(entity, blockPos, Blocks.field_205164_gk.func_176223_P(), 3, PROTECTION_RULE);
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, blockPos, 1.5f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                EffectInstance instance = new EffectInstance((Effect)ModEffects.FROZEN.get(), 100, 0);
                target.func_195064_c(instance);
            }
            iterator.remove();
        }
    }

    private void stopChargeEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 200.0f + this.chargeComponent.getChargeTime());
    }
}

