/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hie;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.IceBlockAvalancheProjectile;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class IceBlockAvalancheAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ice_block_avalanche", new Pair[]{ImmutablePair.of((Object)"Creates a sharp blade made of compressed ice", null)});
    private static final int COOLDOWN = 360;
    private static final int CHARGE_TIME = 100;
    public static final AbilityCore<IceBlockAvalancheAbility> INSTANCE = new AbilityCore.Builder<IceBlockAvalancheAbility>("Ice Block: Avalanche", AbilityCategory.DEVIL_FRUITS, IceBlockAvalancheAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(360.0f), ChargeComponent.getTooltip(100.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceElement(SourceElement.ICE).setSourceType(SourceType.BLUNT).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(100, this::startChargeEvent).addTickEvent(100, this::tickChargeEvent).addEndEvent(100, this::stopChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private IceBlockAvalancheProjectile proj;

    public IceBlockAvalancheAbility(AbilityCore<IceBlockAvalancheAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 100.0f);
    }

    private void startChargeEvent(LivingEntity player, IAbility ability) {
        RayTraceResult ray = WyHelper.rayTraceBlocksAndEntities((Entity)player, 64.0);
        this.removeDuplicate();
        this.proj = (IceBlockAvalancheProjectile)this.projectileComponent.getNewProjectile(player);
        this.proj.func_70107_b(ray.func_216347_e().func_82615_a(), ray.func_216347_e().func_82617_b() + 20.0, ray.func_216347_e().func_82616_c());
        AbilityHelper.setDeltaMovement((Entity)this.proj, 0.0, 0.0, 0.0);
        player.field_70170_p.func_217376_c((Entity)this.proj);
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity != null && this.proj != null && this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.ICE_BLOCK_AVALANCHE.get(), (Entity)entity, this.proj.func_226277_ct_(), this.proj.func_226278_cu_(), this.proj.func_226281_cx_());
        }
    }

    private void stopChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.proj == null) {
            return;
        }
        this.proj.finalized = true;
        AbilityHelper.setDeltaMovement((Entity)this.proj, 0.0, -2.0, 0.0);
        this.cooldownComponent.startCooldown(entity, 360.0f);
    }

    private void removeDuplicate() {
        if (this.proj != null && this.proj.isAddedToWorld()) {
            this.proj.func_70106_y();
        }
    }

    private IceBlockAvalancheProjectile createProjectile(LivingEntity entity) {
        IceBlockAvalancheProjectile proj = new IceBlockAvalancheProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

