/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.horo;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.OutOfBodyAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.PhysicalBodyEntity;

public class YutaiRidatsuAbility
extends OutOfBodyAbility<PhysicalBodyEntity> {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "yutai_ridatsu", new Pair[]{ImmutablePair.of((Object)"The user's spirit leaves their body, allowing them to freely explore the nearby areas.", null)});
    private static final int HOLD_TIME = 1200;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 600;
    public static final AbilityCore<YutaiRidatsuAbility> INSTANCE = new AbilityCore.Builder<YutaiRidatsuAbility>("Yutai Ridatsu", AbilityCategory.DEVIL_FRUITS, YutaiRidatsuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 600.0f), ContinuousComponent.getTooltip(1200.0f)).build();
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::damageTakenEvent);

    public YutaiRidatsuAbility(AbilityCore<YutaiRidatsuAbility> core) {
        super(core);
        this.addComponents(this.damageTakenComponent);
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        AbilityHelper.setDeltaMovement((Entity)entity, 0.0, 5.0, 0.0);
        PhysicalBodyEntity body = new PhysicalBodyEntity(entity.field_70170_p);
        body.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        body.setOwner(entity);
        entity.field_70170_p.func_217376_c((Entity)body);
        body.setParentAbility(this);
        this.setOriginalBody(body);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        float cooldown = Math.max(100.0f, this.continuousComponent.getContinueTime());
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    public float damageTakenEvent(LivingEntity user, IAbility ability, DamageSource damageSource, float damage) {
        if (this.isActive() && damageSource != DamageSource.field_76376_m && !damageSource.func_151517_h()) {
            return 0.0f;
        }
        return damage;
    }

    @Override
    public int getHoldTime() {
        return 1200;
    }

    @Override
    public float getMaxRange() {
        return 80.0f;
    }

    @Override
    public boolean isPhysical() {
        return false;
    }
}

