/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ito.OverheatProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class OverheatAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "overheat", new Pair[]{ImmutablePair.of((Object)"The user shoots a rope made of heated strings at the opponent, exploding upon impact", null)});
    private static final float COOLDOWN = 300.0f;
    public static final AbilityCore<OverheatAbility> INSTANCE = new AbilityCore.Builder<OverheatAbility>("Overheat", AbilityCategory.DEVIL_FRUITS, OverheatAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.EXPLOSION).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public OverheatAbility(AbilityCore<OverheatAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 3.25f, 0.0f);
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM, 7);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private OverheatProjectile createProjectile(LivingEntity entity) {
        OverheatProjectile proj = new OverheatProjectile(entity.field_70170_p, entity, this);
        proj.func_70107_b(proj.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() - (double)0.4f, proj.func_226281_cx_());
        return proj;
    }
}

