/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.ito.TorikagoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.BlackKnightEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ParasiteAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "parasite", new Pair[]{ImmutablePair.of((Object)"By attaching your strings to nearby enemies, they get completely immobilized", null)});
    private static final int COOLDOWN = 600;
    public static final AbilityCore<ParasiteAbility> INSTANCE = new AbilityCore.Builder<ParasiteAbility>("Parasite", AbilityCategory.DEVIL_FRUITS, ParasiteAbility::new).addDescriptionLine(DESCRIPTION).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.PHYSICAL).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public ParasiteAbility(AbilityCore<ParasiteAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability2) {
        TorikagoAbility torikago = AbilityDataCapability.get(entity).getEquippedAbility(TorikagoAbility.INSTANCE);
        if (torikago != null && torikago.isPositionInTorikago(entity.func_233580_cy_())) {
            BlockPos centerPos = torikago.getCenter();
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, centerPos, 60.0f);
            for (LivingEntity target : targets) {
                if (!torikago.isPositionInTorikago(target.func_233580_cy_())) continue;
                ParasiteAbility.inflictParasiteStun(entity, target);
            }
        } else {
            EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, 32.0);
            if (trace.func_216346_c().equals((Object)RayTraceResult.Type.ENTITY) && trace.func_216348_a() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)trace.func_216348_a();
                ParasiteAbility.inflictParasiteStun(entity, target);
            }
        }
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }

    public static void inflictParasiteStun(LivingEntity attacker, LivingEntity target) {
        double targetDoriki;
        if (target instanceof BlackKnightEntity) {
            return;
        }
        if (AbilityHelper.isTargetBlocking(attacker, target)) {
            return;
        }
        IEntityStats attackerEntityStatsData = EntityStatsCapability.get(attacker);
        IEntityStats targetEntityStatsData = EntityStatsCapability.get(target);
        double attackerDoriki = attackerEntityStatsData != null ? attackerEntityStatsData.getDoriki() : 0.0;
        double d = targetDoriki = targetEntityStatsData != null ? targetEntityStatsData.getDoriki() : 0.0;
        if (attackerDoriki < targetDoriki) {
            return;
        }
        if (attackerDoriki == targetDoriki) {
            target.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0, false, false));
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 2, false, false));
        } else {
            target.func_195064_c(new EffectInstance(Effects.field_76440_q, 300, 0, false, false));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 300, 0, false, false));
        }
    }
}

