/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.jiki;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.abilities.sabi.RustSkinAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.PunkCrossProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class PunkCrossAbility
extends Ability {
    private static final int REQUIRED_IRON = 50;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "punk_cross", new Pair[]{ImmutablePair.of((Object)"Uses %s magnetic items and stuns the target in a cross-shaped structure.", (Object)new Object[]{AbilityHelper.mentionText(50)})});
    private static final int COOLDOWN = 200;
    private static final int EFFECT_TIMER = 80;
    public static final AbilityCore<PunkCrossAbility> INSTANCE = new AbilityCore.Builder<PunkCrossAbility>("Punk Cross", AbilityCategory.DEVIL_FRUITS, PunkCrossAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(80.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.METAL).setSourceType(SourceType.BLUNT).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private LivingEntity target;
    private boolean hasTarget;
    private Vector3d lastKnownTargetPos;
    private Vector3d lastKnownProjPos;
    private List<ItemStack> magneticItems = new ArrayList<ItemStack>();

    public PunkCrossAbility(AbilityCore<PunkCrossAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.projectileComponent);
        this.addCanUseCheck(JikiHelper.getMetalicItemsCheck(50));
        this.addUseEvent(this::useEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 80.0f);
    }

    private void tickEvent(LivingEntity entity, IAbility ability) {
        if (!(!this.hasTarget || this.target != null && this.target.func_70089_S() && this.target.func_70644_a((Effect)ModEffects.PUNK_CROSS.get()))) {
            JikiHelper.dropComponentItems(entity, this.lastKnownTargetPos, this.magneticItems);
            this.target = null;
            this.hasTarget = false;
        }
    }

    private void startContinuityEvent(LivingEntity player, IAbility ability) {
        this.target = null;
        this.hasTarget = false;
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(player);
        this.magneticItems = JikiHelper.getMagneticItemsNeeded(inventory, 50.0f);
        this.projectileComponent.shoot(player, 6.0f, 0.0f);
    }

    private void duringContinuityEvent(LivingEntity player, IAbility ability) {
        if (this.target != null) {
            this.lastKnownTargetPos = this.target.func_213303_ch();
        }
        if (!this.hasTarget && this.projectileComponent.hasProjectileAlive()) {
            this.lastKnownProjPos = this.projectileComponent.getShotProjectile().func_213303_ch();
        } else if (!this.hasTarget && !this.projectileComponent.hasProjectileAlive()) {
            JikiHelper.dropComponentItems(player, this.lastKnownProjPos, this.magneticItems);
            this.continuousComponent.stopContinuity(player);
        }
    }

    private void endContinuityEvent(LivingEntity player, IAbility ability) {
        if (this.target != null) {
            this.target.func_195063_d((Effect)ModEffects.PUNK_CROSS.get());
        }
        if (this.target != null) {
            JikiHelper.dropComponentItems(player, this.lastKnownTargetPos, this.magneticItems);
        }
        this.hasTarget = false;
        this.target = null;
        this.lastKnownProjPos = null;
        this.cooldownComponent.startCooldown(player, 200.0f);
    }

    private PunkCrossProjectile createProjectile(LivingEntity entity) {
        PunkCrossProjectile proj = new PunkCrossProjectile(entity.field_70170_p, entity);
        proj.onEntityImpactEvent = target -> {
            RustSkinAbility rustSkinAbility;
            IAbilityData abilityDataProps = AbilityDataCapability.get(target);
            if (abilityDataProps != null && (rustSkinAbility = abilityDataProps.getPassiveAbility(RustSkinAbility.INSTANCE)) != null && !rustSkinAbility.isPaused()) {
                proj.func_174812_G();
                return;
            }
            target.func_195064_c(new EffectInstance((Effect)ModEffects.PUNK_CROSS.get(), 80, 1));
            JikiHelper.spawnAttractEffect((Entity)target);
            this.hasTarget = true;
            this.target = target;
            this.lastKnownTargetPos = target.func_213303_ch();
        };
        proj.onBlockImpactEvent = hitPos -> {
            JikiHelper.dropComponentItems(entity, proj.func_213303_ch(), this.magneticItems);
            this.continuousComponent.stopContinuity(entity);
        };
        return proj;
    }
}

