/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.jiki;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.PunkGibsonAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.PunkGibsonProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RepelAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "repel", new Pair[]{ImmutablePair.of((Object)"Repels all metallic objects or projectiles near the user.", null), ImmutablePair.of((Object)"When %s is active this ability will instead shoot the metalic arm forward like a projectile.", (Object)new Object[]{PunkGibsonAbility.INSTANCE}), ImmutablePair.of((Object)"Repeling enemies affected by %s into other enemies will deal damage and knock them back.", (Object)new Object[]{ModEffects.PUNK_CROSS})});
    private static final int COOLDOWN = 100;
    private static final int HOLD_TIME = 100;
    private static final int RANGE = 20;
    private static final int PUNK_CROSS_RANGE = 3;
    private static final int PUNK_CROSS_DAMAGE = 20;
    public static final AbilityCore<RepelAbility> INSTANCE = new AbilityCore.Builder<RepelAbility>("Repel", AbilityCategory.DEVIL_FRUITS, RepelAbility::new).addDescriptionLine(DESCRIPTION[0]).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f), ContinuousComponent.getTooltip(100.0f), RangeComponent.getTooltip(20.0f, RangeComponent.RangeType.AOE)).addDescriptionLine(AbilityDescriptionLine.NEW_LINE).addDescriptionLine(DESCRIPTION[1]).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).addDescriptionLine(AbilityDescriptionLine.NEW_LINE).addDescriptionLine(DESCRIPTION[2]).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip(20.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private PunkGibsonAbility punkGibson;
    private HashSet<LivingEntity> punkCrossTargets = new HashSet();

    public RepelAbility(AbilityCore<RepelAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.projectileComponent, this.dealDamageComponent, this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        boolean isGibsonActive;
        this.punkGibson = AbilityDataCapability.get(entity).getEquippedAbility(PunkGibsonAbility.INSTANCE);
        boolean bl = isGibsonActive = this.punkGibson != null && this.punkGibson.isContinuous();
        if (isGibsonActive) {
            this.projectileComponent.shoot(entity, 4.0f, 0.5f);
            this.punkGibson.stopItemDrops();
            this.punkGibson.getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.stopContinuity(entity));
        } else {
            this.continuousComponent.triggerContinuity(entity, 100.0f);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        List<Entity> targets = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 20.0, null, Entity.class);
        for (Entity entity2 : targets) {
            ItemEntity item;
            boolean flag = false;
            if (entity2.func_200600_R().func_220341_a(ModTags.Entities.MAGNETIC)) {
                flag = true;
            }
            if (entity2 instanceof LivingEntity) {
                if (this.getIronArmorCoverPercentage((LivingEntity)entity2) >= 0.5f) {
                    flag = true;
                } else if (EntityStatsCapability.get((LivingEntity)entity2).isCyborg()) {
                    flag = true;
                } else if (((LivingEntity)entity2).func_70644_a((Effect)ModEffects.PUNK_CROSS.get())) {
                    flag = true;
                    ((EffectInstanceMixin)((LivingEntity)entity2).func_70660_b((Effect)ModEffects.PUNK_CROSS.get())).setAmplifier(0);
                    this.punkCrossTargets.add((LivingEntity)entity2);
                }
            }
            if (flag) {
                Vector3d dist = entity2.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_186678_a(2.0);
                AbilityHelper.setDeltaMovement(entity2, dist.field_72450_a, dist.field_72448_b, dist.field_72449_c);
            }
            if (!(entity2 instanceof ItemEntity) || (item = (ItemEntity)entity2).func_92059_d().func_190926_b() || !item.func_92059_d().func_77973_b().func_206844_a(ModTags.Items.MAGNETIC)) continue;
            Vector3d vec = item.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72441_c(0.0, -1.0, 0.0);
            double speedReduction = 8.0;
            double speed = 2.0;
            double xSpeed = Math.min(speed, -vec.field_72450_a / speedReduction);
            double zSpeed = Math.min(speed, -vec.field_72449_c / speedReduction);
            AbilityHelper.setDeltaMovement((Entity)item, -xSpeed, 0.1, -zSpeed);
        }
        for (LivingEntity livingEntity : this.punkCrossTargets) {
            if (!livingEntity.func_70089_S() || livingEntity.func_233570_aj_()) continue;
            List<LivingEntity> nearby = this.rangeComponent.getTargetsInArea(entity, 3.0f);
            nearby.remove(livingEntity);
            for (LivingEntity target2 : nearby) {
                if (!this.dealDamageComponent.hurtTarget(entity, target2, 20.0f)) continue;
                Vector3d speed = WyHelper.propulsion(entity, 2.0, 2.0);
                AbilityHelper.setDeltaMovement((Entity)target2, speed.field_72450_a, 0.5, speed.field_72449_c);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    private PunkGibsonProjectile createProjectile(LivingEntity entity) {
        if (this.punkGibson != null) {
            PunkGibsonProjectile proj = new PunkGibsonProjectile(entity.field_70170_p, entity, this.punkGibson.getMagneticItems());
            return proj;
        }
        PunkGibsonProjectile proj = new PunkGibsonProjectile(entity.field_70170_p, entity, new ArrayList<ItemStack>());
        return proj;
    }

    public float getIronArmorCoverPercentage(LivingEntity target) {
        Iterable iterable = target.func_184193_aE();
        int i = 0;
        int j = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_206844_a(ModTags.Items.MAGNETIC)) {
                ++j;
            }
            ++i;
        }
        return i > 0 ? (float)j / (float)i : 0.0f;
    }
}

