/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.karu;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.karu.KarmaAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class IngaZarashiAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "inga_zarashi", new Pair[]{ImmutablePair.of((Object)"Increases your physical prowess depending on how much damage you have in your %s counter", (Object)new Object[]{AbilityHelper.mentionText(ModI18n.GUI_KARMA)})});
    private static final int MIN_COOLDOWN = 20;
    private static final int MAX_COOLDOWN = 240;
    public static final AbilityCore<IngaZarashiAbility> INSTANCE = new AbilityCore.Builder<IngaZarashiAbility>("Inga Zarashi", AbilityCategory.DEVIL_FRUITS, IngaZarashiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f, 240.0f), ContinuousComponent.getTooltip()).build();
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("06141405-6e5c-4b98-a8f7-230e0ffb96bc");
    private static final UUID ATTACK_MODIFIER_UUID = UUID.fromString("7ddb710f-a497-4f64-b272-8fcc9955b401");
    private static final UUID REACH_MODIFIER_UUID = UUID.fromString("dc0d06d6-ffd6-49d8-b484-da232b78fd41");
    private Optional<KarmaAbility> karmaAbility = Optional.empty();

    public IngaZarashiAbility(AbilityCore<IngaZarashiAbility> core) {
        super(core);
        this.addCanUseCheck(this::canUse);
        this.continuousComponent.addTickEvent(this::duringContinuousEvent);
        this.continuousComponent.addEndEvent(this::endContinuousEvent);
    }

    private void duringContinuousEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() % 20.0f == 0.0f && this.karmaAbility.isPresent()) {
            this.updateKarma(entity);
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        float cooldown = MathHelper.func_76131_a((float)this.continuousComponent.getContinueTime(), (float)20.0f, (float)240.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private AbilityUseResult canUse(LivingEntity entity, IAbility ability) {
        IAbilityData props = AbilityDataCapability.get(entity);
        KarmaAbility karma = props.getPassiveAbility(KarmaAbility.INSTANCE);
        if (karma == null) {
            return AbilityUseResult.fail(null);
        }
        this.karmaAbility = Optional.ofNullable(karma);
        return AbilityUseResult.success();
    }

    private void updateKarma(LivingEntity entity) {
        if (this.karmaAbility.get().getPrevKarma() != this.karmaAbility.get().getKarma()) {
            this.statsComponent.removeModifiers(entity);
            for (Map.Entry entry : this.getAttributes().entries()) {
                this.statsComponent.removeAttributeModifier((Attribute)entry.getKey());
                this.statsComponent.addAttributeModifier((Attribute)entry.getKey(), (AttributeModifier)entry.getValue());
            }
            this.statsComponent.applyModifiers(entity);
            this.morphComponent.updateMorphSize(entity);
            this.karmaAbility.get().setPrevKarma(this.karmaAbility.get().getKarma());
        }
        this.karmaAbility.get().addKarma(entity, -(this.karmaAbility.get().getKarma() / 100.0f));
    }

    private Multimap<Attribute, AttributeModifier> getAttributes() {
        HashMultimap map = HashMultimap.create();
        float karma = this.karmaAbility.get().getKarma();
        double armorMod = Math.min(karma / 100.0f * 8.0f, 8.0f);
        double attackMod = Math.min(karma / 100.0f * 10.0f, 10.0f);
        double reachMod = Math.min((double)(karma / 100.0f) * 2.5, 2.5);
        map.put((Object)Attributes.field_233826_i_, (Object)new AbilityAttributeModifier(ARMOR_MODIFIER_UUID, INSTANCE, "Karma Armor Modifier", armorMod, AttributeModifier.Operation.ADDITION));
        map.put((Object)ModAttributes.PUNCH_DAMAGE.get(), (Object)new AbilityAttributeModifier(ATTACK_MODIFIER_UUID, INSTANCE, "Karma Attack Modifier", attackMod, AttributeModifier.Operation.ADDITION));
        AbilityAttributeModifier reachAttribute = new AbilityAttributeModifier(REACH_MODIFIER_UUID, INSTANCE, "Karma Reach Modifier", reachMod, AttributeModifier.Operation.ADDITION);
        map.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)reachAttribute);
        map.put((Object)ModAttributes.ATTACK_RANGE.get(), (Object)reachAttribute);
        return map;
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.INGA_ZARASHI.get();
    }
}

