/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kilo;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KiloPress10000Ability
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "10_000_kilo_press", new Pair[]{ImmutablePair.of((Object)"Makes the user become extremely heavy, crashing down on enemies from above crushes them, damage is calculated based on the fall distance.", null)});
    private static final float HOLD_TIME = 1200.0f;
    private static final float MIN_COOLDOWN = 20.0f;
    private static final float MAX_COOLDOWN = 1220.0f;
    private static final float MIN_DAMAGE = 1.0f;
    private static final float MAX_DAMAGE = 80.0f;
    private static final float RANGE = 5.0f;
    public static final AbilityCore<KiloPress10000Ability> INSTANCE = new AbilityCore.Builder<KiloPress10000Ability>("10,000 Kilo Press", AbilityCategory.DEVIL_FRUITS, KiloPress10000Ability::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f, 1220.0f), ContinuousComponent.getTooltip(1200.0f), DealDamageComponent.getTooltip(1.0f, 80.0f), RangeComponent.getTooltip(5.0f, RangeComponent.RangeType.AOE), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private static final AbilityAttributeModifier KILO_PRESS_JUMP_HEIGHT = new AbilityAttributeModifier(UUID.fromString("692759d2-5d8d-4809-912d-86ad362f8f95"), INSTANCE, "Kilo Press Jump Height Modifier", -10.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier KILO_PRESS_KNOCKBACK = new AbilityAttributeModifier(UUID.fromString("f3597992-9268-4a40-9363-555cf06c7771"), INSTANCE, "Kilo Press Knockback Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier KILO_PRESS_MOVEMENT_SPEED = new AbilityAttributeModifier(UUID.fromString("d668cefb-4e31-4e7b-842b-7a1c8de82f69"), INSTANCE, "Kilo Press Movement Speed Modifier", -0.02, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent).addTickEvent(100, this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTaken);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private double initialPosY = 0.0;

    public KiloPress10000Ability(AbilityCore<KiloPress10000Ability> core) {
        super(core);
        this.isNew = true;
        Predicate<LivingEntity> isContinuityActive = entity -> this.continuousComponent.isContinuous();
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.JUMP_HEIGHT, (AttributeModifier)KILO_PRESS_JUMP_HEIGHT, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KILO_PRESS_KNOCKBACK, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)KILO_PRESS_MOVEMENT_SPEED, isContinuityActive);
        this.addComponents(this.continuousComponent, this.damageTakenComponent, this.dealDamageComponent, this.rangeComponent, this.changeStatsComponent, this.animationComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.KILO_PRESS, -1, user -> this.isContinuous() && !user.func_233570_aj_());
        this.changeStatsComponent.applyModifiers(entity);
        AbilityHelper.setDeltaMovement((Entity)entity, entity.func_213322_ci().field_72450_a, -5.0, entity.func_213322_ci().field_72449_c);
        this.initialPosY = !entity.func_233570_aj_() ? entity.func_226278_cu_() : 0.0;
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_233570_aj_() && this.initialPosY > 0.0 && entity.func_226278_cu_() < this.initialPosY) {
            float damage = (float)MathHelper.func_151237_a((double)(this.initialPosY - entity.func_226278_cu_()), (double)1.0, (double)80.0);
            if (damage > 0.0f) {
                List<LivingEntity> nearTargets = this.rangeComponent.getTargetsInArea(entity, 1.0f);
                for (LivingEntity target : nearTargets) {
                    this.dealDamageComponent.hurtTarget(entity, target, damage);
                }
                List<LivingEntity> farTargets = this.rangeComponent.getTargetsInArea(entity, 5.0f);
                farTargets.removeAll(nearTargets);
                ModDamageSource farSource = ((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).markIndirectDamage();
                for (LivingEntity target : farTargets) {
                    this.dealDamageComponent.hurtTarget(entity, target, damage, farSource);
                }
                this.initialPosY = 0.0;
            }
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GREAT_STOMP.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.changeStatsComponent.removeModifiers(entity);
        float cooldown = 20.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damageSource == DamageSource.field_76379_h) {
            return 0.0f;
        }
        return damage;
    }
}

