/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.magu;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.LavaImmuneProtectionRule;

public class LavaFlowAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "lava_flow", new Pair[]{ImmutablePair.of((Object)"The user covers their legs into lava creating a path while walking trough it", null)});
    private static final int COOLDOWN = 300;
    private static final int HOLD_TIME = 100;
    public static final AbilityCore<LavaFlowAbility> INSTANCE = new AbilityCore.Builder<LavaFlowAbility>("Lava Flow", AbilityCategory.DEVIL_FRUITS, LavaFlowAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), ContinuousComponent.getTooltip(100.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(DefaultProtectionRules.CORE_FOLIAGE_ORE, LavaImmuneProtectionRule.INSTANCE).addApprovedMaterials(Material.field_151587_i).build();
    private int originY = -1;

    public LavaFlowAbility(AbilityCore<LavaFlowAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent);
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.originY = entity.func_233580_cy_().func_177956_o() - 5;
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        boolean canPlaceBlocks;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.originY < 0) {
            return;
        }
        BlockPos pos = entity.func_233580_cy_().func_177977_b();
        BlockState state = entity.field_70170_p.func_180495_p(pos);
        boolean isBlockBelowOrigin = pos.func_177956_o() < this.originY;
        boolean areEyesInLava = entity.func_208600_a((ITag)FluidTags.field_206960_b);
        boolean bl = canPlaceBlocks = GRIEF_RULE.check(entity.field_70170_p, pos, state) && !areEyesInLava;
        if (canPlaceBlocks) {
            AbilityHelper.createFilledSphere(entity.field_70170_p, (int)entity.func_226277_ct_(), (int)entity.func_226278_cu_() - 2, (int)entity.func_226281_cx_(), 4, Blocks.field_150353_l, GRIEF_RULE);
        } else if (areEyesInLava && !isBlockBelowOrigin) {
            AbilityHelper.createFilledSphere(entity.field_70170_p, (int)entity.func_226277_ct_(), (int)entity.func_226278_cu_() + 1, (int)entity.func_226281_cx_(), 3, Blocks.field_150353_l, GRIEF_RULE);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }
}

