/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.marineloyalty;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MusterAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "muster", new Pair[]{ImmutablePair.of((Object)"The user musters some reinforcements.", null)});
    private static final float COOLDOWN = 1200.0f;
    public static final AbilityCore<MusterAbility> INSTANCE = new AbilityCore.Builder<MusterAbility>("Muster", AbilityCategory.FACTION, MusterAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(1200.0f)).setUnlockCheck(MusterAbility::canUnlock).build();

    public MusterAbility(AbilityCore<MusterAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        BlockPos spawnPos;
        EntityType gruntEntity = (EntityType)ModEntities.MARINE_GRUNT.get();
        EntityType captain = (EntityType)ModEntities.MARINE_CAPTAIN.get();
        int i = 0;
        while ((double)i < WyHelper.randomWithRange(3, 10)) {
            spawnPos = WyHelper.findOnGroundSpawnLocation(entity.field_70170_p, gruntEntity, entity.func_233580_cy_(), 10);
            if (spawnPos != null) {
                gruntEntity.func_220342_a((ServerWorld)entity.field_70170_p, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
            }
            ++i;
        }
        if (entity.field_70170_p instanceof ServerWorld) {
            i = 0;
            while ((double)i < WyHelper.randomWithRange(1, 3)) {
                spawnPos = WyHelper.findOnGroundSpawnLocation(entity.field_70170_p, captain, entity.func_233580_cy_(), 10);
                captain.func_220342_a((ServerWorld)entity.field_70170_p, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
                ++i;
            }
        }
        this.cooldownComponent.startCooldown(entity, 1200.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get(entity);
        return props.hasMarineRank(FactionHelper.MarineRank.CAPTAIN);
    }
}

