/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.marineloyalty;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SmallMusterAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "small_muster", new Pair[]{ImmutablePair.of((Object)"The user musters a few low level reinforcements.", null)});
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<SmallMusterAbility> INSTANCE = new AbilityCore.Builder<SmallMusterAbility>("Small Muster", AbilityCategory.FACTION, SmallMusterAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f)).setUnlockCheck(SmallMusterAbility::canUnlock).build();

    public SmallMusterAbility(AbilityCore<SmallMusterAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        EntityType gruntEntity = (EntityType)ModEntities.MARINE_GRUNT.get();
        int i = 0;
        while ((double)i < WyHelper.randomWithRange(1, 5)) {
            BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation(entity.field_70170_p, gruntEntity, entity.func_233580_cy_(), 10);
            if (spawnPos != null) {
                gruntEntity.func_220342_a((ServerWorld)entity.field_70170_p, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
            }
            ++i;
        }
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get(entity);
        return props.hasMarineRank(FactionHelper.MarineRank.LIEUTENANT);
    }
}

